@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Role management policy
 * @property effectiveRules The readonly computed rule applied to the policy.
 * @property id The role management policy Id.
 * @property name The role management policy name.
 * @property policyAssignmentProperties Additional properties of scope, role definition and policy
 * @property policyId The policy id role management policy assignment.
 * @property roleDefinitionId The role definition of management policy assignment.
 * @property scope The role management policy scope.
 * @property type The role management policy type.
 */
public data class GetRoleManagementPolicyAssignmentResult(
    public val effectiveRules: List<Any>,
    public val id: String,
    public val name: String,
    public val policyAssignmentProperties: PolicyAssignmentPropertiesResponse,
    public val policyId: String? = null,
    public val roleDefinitionId: String? = null,
    public val scope: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetRoleManagementPolicyAssignmentResult):
            GetRoleManagementPolicyAssignmentResult = GetRoleManagementPolicyAssignmentResult(
            effectiveRules = javaType.effectiveRules().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            policyAssignmentProperties = javaType.policyAssignmentProperties().let({ args0 ->
                com.pulumi.azurenative.authorization.kotlin.outputs.PolicyAssignmentPropertiesResponse.Companion.toKotlin(args0)
            }),
            policyId = javaType.policyId().map({ args0 -> args0 }).orElse(null),
            roleDefinitionId = javaType.roleDefinitionId().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
