@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The definition of a parameter that can be provided to the policy.
 * @property allowedValues The allowed values for the parameter.
 * @property defaultValue The default value for the parameter if no value is provided.
 * @property metadata General metadata for the parameter.
 * @property schema Provides validation of parameter inputs during assignment using a self-defined JSON schema. This property is only supported for object-type parameters and follows the Json.NET Schema 2019-09 implementation. You can learn more about using schemas at https://json-schema.org/ and test draft schemas at https://www.jsonschemavalidator.net/.
 * @property type The data type of the parameter.
 */
public data class ParameterDefinitionsValueResponse(
    public val allowedValues: List<Any>? = null,
    public val defaultValue: Any? = null,
    public val metadata: ParameterDefinitionsValueResponseMetadata? = null,
    public val schema: Any? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.ParameterDefinitionsValueResponse):
            ParameterDefinitionsValueResponse = ParameterDefinitionsValueResponse(
            allowedValues = javaType.allowedValues().map({ args0 -> args0 }),
            defaultValue = javaType.defaultValue().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponseMetadata.Companion.toKotlin(args0)
                })
            }).orElse(null),
            schema = javaType.schema().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
