@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin

import com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfilePropertiesResponse
import com.pulumi.azurenative.automanage.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfilePropertiesResponse.Companion.toKotlin as configurationProfilePropertiesResponseToKotlin
import com.pulumi.azurenative.automanage.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConfigurationProfile].
 */
@PulumiTagMarker
public class ConfigurationProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationProfileArgs = ConfigurationProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationProfileArgsBuilder.() -> Unit) {
        val builder = ConfigurationProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConfigurationProfile {
        val builtJavaResource =
            com.pulumi.azurenative.automanage.ConfigurationProfile(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationProfile(builtJavaResource)
    }
}

/**
 * Definition of the configuration profile.
 * Azure REST API version: 2022-05-04.
 * ## Example Usage
 * ### Create or update configuration profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfile = new AzureNative.Automanage.ConfigurationProfile("configurationProfile", new()
 *     {
 *         ConfigurationProfileName = "customConfigurationProfile",
 *         Location = "East US",
 *         Properties = new AzureNative.Automanage.Inputs.ConfigurationProfilePropertiesArgs
 *         {
 *             Configuration =
 *             {
 *                 { "Antimalware/Enable", false },
 *                 { "AzureSecurityCenter/Enable", true },
 *                 { "Backup/Enable", false },
 *                 { "BootDiagnostics/Enable", true },
 *                 { "ChangeTrackingAndInventory/Enable", true },
 *                 { "GuestConfiguration/Enable", true },
 *                 { "LogAnalytics/Enable", true },
 *                 { "UpdateManagement/Enable", true },
 *                 { "VMInsights/Enable", true },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *         Tags =
 *         {
 *             { "Organization", "Administration" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automanage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automanage.NewConfigurationProfile(ctx, "configurationProfile", &automanage.ConfigurationProfileArgs{
 * 			ConfigurationProfileName: pulumi.String("customConfigurationProfile"),
 * 			Location:                 pulumi.String("East US"),
 * 			Properties: &automanage.ConfigurationProfilePropertiesArgs{
 * 				Configuration: pulumi.Any{
 * 					Antimalware / Enable:                false,
 * 					AzureSecurityCenter / Enable:        true,
 * 					Backup / Enable:                     false,
 * 					BootDiagnostics / Enable:            true,
 * 					ChangeTrackingAndInventory / Enable: true,
 * 					GuestConfiguration / Enable:         true,
 * 					LogAnalytics / Enable:               true,
 * 					UpdateManagement / Enable:           true,
 * 					VMInsights / Enable:                 true,
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"Organization": pulumi.String("Administration"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automanage.ConfigurationProfile;
 * import com.pulumi.azurenative.automanage.ConfigurationProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfile = new ConfigurationProfile("configurationProfile", ConfigurationProfileArgs.builder()
 *             .configurationProfileName("customConfigurationProfile")
 *             .location("East US")
 *             .properties(Map.of("configuration", Map.ofEntries(
 *                 Map.entry("Antimalware/Enable", false),
 *                 Map.entry("AzureSecurityCenter/Enable", true),
 *                 Map.entry("Backup/Enable", false),
 *                 Map.entry("BootDiagnostics/Enable", true),
 *                 Map.entry("ChangeTrackingAndInventory/Enable", true),
 *                 Map.entry("GuestConfiguration/Enable", true),
 *                 Map.entry("LogAnalytics/Enable", true),
 *                 Map.entry("UpdateManagement/Enable", true),
 *                 Map.entry("VMInsights/Enable", true)
 *             )))
 *             .resourceGroupName("myResourceGroupName")
 *             .tags(Map.of("Organization", "Administration"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automanage:ConfigurationProfile customConfigurationProfile /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automanage/configurationProfiles/{configurationProfileName}
 * ```
 */
public class ConfigurationProfile internal constructor(
    override val javaResource: com.pulumi.azurenative.automanage.ConfigurationProfile,
) : KotlinCustomResource(javaResource, ConfigurationProfileMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the configuration profile.
     */
    public val properties: Output<ConfigurationProfilePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                configurationProfilePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationProfileMapper : ResourceMapper<ConfigurationProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automanage.ConfigurationProfile::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationProfile = ConfigurationProfile(
        javaResource
            as com.pulumi.azurenative.automanage.ConfigurationProfile,
    )
}

/**
 * @see [ConfigurationProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationProfile].
 */
public suspend fun configurationProfile(
    name: String,
    block: suspend ConfigurationProfileResourceBuilder.() -> Unit,
): ConfigurationProfile {
    val builder = ConfigurationProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationProfile(name: String): ConfigurationProfile {
    val builder = ConfigurationProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
