@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin

import com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfileAssignmentPropertiesResponse
import com.pulumi.azurenative.automanage.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfileAssignmentPropertiesResponse.Companion.toKotlin as configurationProfileAssignmentPropertiesResponseToKotlin
import com.pulumi.azurenative.automanage.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConfigurationProfileAssignment].
 */
@PulumiTagMarker
public class ConfigurationProfileAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationProfileAssignmentArgs = ConfigurationProfileAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationProfileAssignmentArgsBuilder.() -> Unit) {
        val builder = ConfigurationProfileAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConfigurationProfileAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.automanage.ConfigurationProfileAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationProfileAssignment(builtJavaResource)
    }
}

/**
 * Configuration profile assignment is an association between a VM and automanage profile configuration.
 * Azure REST API version: 2022-05-04. Prior API version in Azure Native 1.x: 2020-06-30-preview.
 * ## Example Usage
 * ### Create or update configuration profile assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfileAssignment = new AzureNative.Automanage.ConfigurationProfileAssignment("configurationProfileAssignment", new()
 *     {
 *         ConfigurationProfileAssignmentName = "default",
 *         Properties = new AzureNative.Automanage.Inputs.ConfigurationProfileAssignmentPropertiesArgs
 *         {
 *             ConfigurationProfile = "/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction",
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *         VmName = "myVMName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automanage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automanage.NewConfigurationProfileAssignment(ctx, "configurationProfileAssignment", &automanage.ConfigurationProfileAssignmentArgs{
 * 			ConfigurationProfileAssignmentName: pulumi.String("default"),
 * 			Properties: &automanage.ConfigurationProfileAssignmentPropertiesArgs{
 * 				ConfigurationProfile: pulumi.String("/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 			VmName:            pulumi.String("myVMName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automanage.ConfigurationProfileAssignment;
 * import com.pulumi.azurenative.automanage.ConfigurationProfileAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfileAssignment = new ConfigurationProfileAssignment("configurationProfileAssignment", ConfigurationProfileAssignmentArgs.builder()
 *             .configurationProfileAssignmentName("default")
 *             .properties(Map.of("configurationProfile", "/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction"))
 *             .resourceGroupName("myResourceGroupName")
 *             .vmName("myVMName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automanage:ConfigurationProfileAssignment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}
 * ```
 */
public class ConfigurationProfileAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.automanage.ConfigurationProfileAssignment,
) : KotlinCustomResource(javaResource, ConfigurationProfileAssignmentMapper) {
    /**
     * Azure resource id. Indicates if this resource is managed by another Azure resource.
     */
    public val managedBy: Output<String>
        get() = javaResource.managedBy().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the configuration profile assignment.
     */
    public val properties: Output<ConfigurationProfileAssignmentPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                configurationProfileAssignmentPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationProfileAssignmentMapper : ResourceMapper<ConfigurationProfileAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automanage.ConfigurationProfileAssignment::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationProfileAssignment =
        ConfigurationProfileAssignment(
            javaResource as
                com.pulumi.azurenative.automanage.ConfigurationProfileAssignment,
        )
}

/**
 * @see [ConfigurationProfileAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationProfileAssignment].
 */
public suspend fun configurationProfileAssignment(
    name: String,
    block: suspend ConfigurationProfileAssignmentResourceBuilder.() -> Unit,
):
    ConfigurationProfileAssignment {
    val builder = ConfigurationProfileAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationProfileAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationProfileAssignment(name: String): ConfigurationProfileAssignment {
    val builder = ConfigurationProfileAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
