@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.inputs

import com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferenceVmBackupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Automanage configuration profile VM Backup preferences.
 * @property instantRpRetentionRangeInDays Instant RP retention policy range in days
 * @property retentionPolicy Retention policy with the details on backup copy retention ranges.
 * @property schedulePolicy Backup schedule specified as part of backup policy.
 * @property timeZone TimeZone optional input as string. For example: Pacific Standard Time
 */
public data class ConfigurationProfilePreferenceVmBackupArgs(
    public val instantRpRetentionRangeInDays: Output<Int>? = null,
    public val retentionPolicy: Output<String>? = null,
    public val schedulePolicy: Output<String>? = null,
    public val timeZone: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferenceVmBackupArgs> {
    override fun toJava():
        com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferenceVmBackupArgs =
        com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferenceVmBackupArgs.builder()
            .instantRpRetentionRangeInDays(instantRpRetentionRangeInDays?.applyValue({ args0 -> args0 }))
            .retentionPolicy(retentionPolicy?.applyValue({ args0 -> args0 }))
            .schedulePolicy(schedulePolicy?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationProfilePreferenceVmBackupArgs].
 */
@PulumiTagMarker
public class ConfigurationProfilePreferenceVmBackupArgsBuilder internal constructor() {
    private var instantRpRetentionRangeInDays: Output<Int>? = null

    private var retentionPolicy: Output<String>? = null

    private var schedulePolicy: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value Instant RP retention policy range in days
     */
    @JvmName("scyfhyiwjqdawotl")
    public suspend fun instantRpRetentionRangeInDays(`value`: Output<Int>) {
        this.instantRpRetentionRangeInDays = value
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("isdjpcrjsichfpee")
    public suspend fun retentionPolicy(`value`: Output<String>) {
        this.retentionPolicy = value
    }

    /**
     * @param value Backup schedule specified as part of backup policy.
     */
    @JvmName("mswtunukggoeqinp")
    public suspend fun schedulePolicy(`value`: Output<String>) {
        this.schedulePolicy = value
    }

    /**
     * @param value TimeZone optional input as string. For example: Pacific Standard Time
     */
    @JvmName("sfyucnxdpnfsnpci")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Instant RP retention policy range in days
     */
    @JvmName("mbgrccsvupjhpmro")
    public suspend fun instantRpRetentionRangeInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instantRpRetentionRangeInDays = mapped
    }

    /**
     * @param value Retention policy with the details on backup copy retention ranges.
     */
    @JvmName("kcknnrbgapqrrmcr")
    public suspend fun retentionPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param value Backup schedule specified as part of backup policy.
     */
    @JvmName("wdvgwbqbjlihjfcn")
    public suspend fun schedulePolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedulePolicy = mapped
    }

    /**
     * @param value TimeZone optional input as string. For example: Pacific Standard Time
     */
    @JvmName("amemdntepbebwmdo")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): ConfigurationProfilePreferenceVmBackupArgs =
        ConfigurationProfilePreferenceVmBackupArgs(
            instantRpRetentionRangeInDays = instantRpRetentionRangeInDays,
            retentionPolicy = retentionPolicy,
            schedulePolicy = schedulePolicy,
            timeZone = timeZone,
        )
}
