@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.inputs

import com.pulumi.azurenative.automanage.inputs.GetConfigurationProfileAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationProfileAssignmentName The configuration profile assignment name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vmName The name of the virtual machine.
 */
public data class GetConfigurationProfileAssignmentPlainArgs(
    public val configurationProfileAssignmentName: String,
    public val resourceGroupName: String,
    public val vmName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.automanage.inputs.GetConfigurationProfileAssignmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.automanage.inputs.GetConfigurationProfileAssignmentPlainArgs =
        com.pulumi.azurenative.automanage.inputs.GetConfigurationProfileAssignmentPlainArgs.builder()
            .configurationProfileAssignmentName(configurationProfileAssignmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmName(vmName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationProfileAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationProfileAssignmentPlainArgsBuilder internal constructor() {
    private var configurationProfileAssignmentName: String? = null

    private var resourceGroupName: String? = null

    private var vmName: String? = null

    /**
     * @param value The configuration profile assignment name.
     */
    @JvmName("ukjtuerownkvmfdq")
    public suspend fun configurationProfileAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationProfileAssignmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ydqmpbaosyvotgcb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("ddpfjecxsrpaacfv")
    public suspend fun vmName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmName = mapped
    }

    internal fun build(): GetConfigurationProfileAssignmentPlainArgs =
        GetConfigurationProfileAssignmentPlainArgs(
            configurationProfileAssignmentName = configurationProfileAssignmentName ?: throw
                PulumiNullFieldException("configurationProfileAssignmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            vmName = vmName ?: throw PulumiNullFieldException("vmName"),
        )
}
