@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.inputs

import com.pulumi.azurenative.automanage.inputs.GetConfigurationProfileHCRPAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationProfileAssignmentName The configuration profile assignment name.
 * @property machineName The name of the Arc machine.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetConfigurationProfileHCRPAssignmentPlainArgs(
    public val configurationProfileAssignmentName: String,
    public val machineName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.automanage.inputs.GetConfigurationProfileHCRPAssignmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.automanage.inputs.GetConfigurationProfileHCRPAssignmentPlainArgs =
        com.pulumi.azurenative.automanage.inputs.GetConfigurationProfileHCRPAssignmentPlainArgs.builder()
            .configurationProfileAssignmentName(configurationProfileAssignmentName.let({ args0 -> args0 }))
            .machineName(machineName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationProfileHCRPAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationProfileHCRPAssignmentPlainArgsBuilder internal constructor() {
    private var configurationProfileAssignmentName: String? = null

    private var machineName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The configuration profile assignment name.
     */
    @JvmName("iadapvanhkagvikt")
    public suspend fun configurationProfileAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationProfileAssignmentName = mapped
    }

    /**
     * @param value The name of the Arc machine.
     */
    @JvmName("thcjnffsidndcatf")
    public suspend fun machineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.machineName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rwbsglkdpbrqskbu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConfigurationProfileHCRPAssignmentPlainArgs =
        GetConfigurationProfileHCRPAssignmentPlainArgs(
            configurationProfileAssignmentName = configurationProfileAssignmentName ?: throw
                PulumiNullFieldException("configurationProfileAssignmentName"),
            machineName = machineName ?: throw PulumiNullFieldException("machineName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
