@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Automanage configuration profile assignment properties.
 * @property configurationProfile The Automanage configurationProfile ARM Resource URI.
 * @property status The status of onboarding, which only appears in the response.
 * @property targetId The target VM resource URI
 */
public data class ConfigurationProfileAssignmentPropertiesResponse(
    public val configurationProfile: String? = null,
    public val status: String,
    public val targetId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automanage.outputs.ConfigurationProfileAssignmentPropertiesResponse):
            ConfigurationProfileAssignmentPropertiesResponse =
            ConfigurationProfileAssignmentPropertiesResponse(
                configurationProfile = javaType.configurationProfile().map({ args0 -> args0 }).orElse(null),
                status = javaType.status(),
                targetId = javaType.targetId(),
            )
    }
}
