@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.ConnectionTypeAssociationPropertyResponse
import com.pulumi.azurenative.automation.kotlin.outputs.ConnectionTypeAssociationPropertyResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Connection].
 */
@PulumiTagMarker
public class ConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionArgs = ConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionArgsBuilder.() -> Unit) {
        val builder = ConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Connection {
        val builtJavaResource = com.pulumi.azurenative.automation.Connection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Connection(builtJavaResource)
    }
}

/**
 * Definition of the connection.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connection = new AzureNative.Automation.Connection("connection", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount28",
 *         ConnectionName = "mysConnection",
 *         ConnectionType = new AzureNative.Automation.Inputs.ConnectionTypeAssociationPropertyArgs
 *         {
 *             Name = "Azure",
 *         },
 *         Description = "my description goes here",
 *         FieldDefinitionValues =
 *         {
 *             { "AutomationCertificateName", "mysCertificateName" },
 *             { "SubscriptionID", "subid" },
 *         },
 *         Name = "mysConnection",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewConnection(ctx, "connection", &automation.ConnectionArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount28"),
 * 			ConnectionName:        pulumi.String("mysConnection"),
 * 			ConnectionType: &automation.ConnectionTypeAssociationPropertyArgs{
 * 				Name: pulumi.String("Azure"),
 * 			},
 * 			Description: pulumi.String("my description goes here"),
 * 			FieldDefinitionValues: pulumi.StringMap{
 * 				"AutomationCertificateName": pulumi.String("mysCertificateName"),
 * 				"SubscriptionID":            pulumi.String("subid"),
 * 			},
 * 			Name:              pulumi.String("mysConnection"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Connection;
 * import com.pulumi.azurenative.automation.ConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connection = new Connection("connection", ConnectionArgs.builder()
 *             .automationAccountName("myAutomationAccount28")
 *             .connectionName("mysConnection")
 *             .connectionType(Map.of("name", "Azure"))
 *             .description("my description goes here")
 *             .fieldDefinitionValues(Map.ofEntries(
 *                 Map.entry("AutomationCertificateName", "mysCertificateName"),
 *                 Map.entry("SubscriptionID", "subid")
 *             ))
 *             .name("mysConnection")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Connection mysConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/connections/{connectionName}
 * ```
 */
public class Connection internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.Connection,
) : KotlinCustomResource(javaResource, ConnectionMapper) {
    /**
     * Gets or sets the connectionType of the connection.
     */
    public val connectionType: Output<ConnectionTypeAssociationPropertyResponse>?
        get() = javaResource.connectionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the creation time.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the field definition values of the connection.
     */
    public val fieldDefinitionValues: Output<Map<String, String>>
        get() = javaResource.fieldDefinitionValues().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Gets the last modified time.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectionMapper : ResourceMapper<Connection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.Connection::class == javaResource::class

    override fun map(javaResource: Resource): Connection = Connection(
        javaResource as
            com.pulumi.azurenative.automation.Connection,
    )
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connection].
 */
public suspend fun connection(name: String, block: suspend ConnectionResourceBuilder.() -> Unit):
    Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connection(name: String): Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
