@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.ConnectionTypeArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.FieldDefinitionArgs
import com.pulumi.azurenative.automation.kotlin.inputs.FieldDefinitionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the connection type.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update connection type
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionType = new AzureNative.Automation.ConnectionType("connectionType", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount22",
 *         ConnectionTypeName = "myCT",
 *         FieldDefinitions =
 *         {
 *             { "myBoolField", new AzureNative.Automation.Inputs.FieldDefinitionArgs
 *             {
 *                 IsEncrypted = false,
 *                 IsOptional = false,
 *                 Type = "bool",
 *             } },
 *             { "myStringField", new AzureNative.Automation.Inputs.FieldDefinitionArgs
 *             {
 *                 IsEncrypted = false,
 *                 IsOptional = false,
 *                 Type = "string",
 *             } },
 *             { "myStringFieldEncrypted", new AzureNative.Automation.Inputs.FieldDefinitionArgs
 *             {
 *                 IsEncrypted = true,
 *                 IsOptional = false,
 *                 Type = "string",
 *             } },
 *         },
 *         IsGlobal = false,
 *         Name = "myCT",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewConnectionType(ctx, "connectionType", &automation.ConnectionTypeArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount22"),
 * 			ConnectionTypeName:    pulumi.String("myCT"),
 * 			FieldDefinitions: automation.FieldDefinitionMap{
 * 				"myBoolField": &automation.FieldDefinitionArgs{
 * 					IsEncrypted: pulumi.Bool(false),
 * 					IsOptional:  pulumi.Bool(false),
 * 					Type:        pulumi.String("bool"),
 * 				},
 * 				"myStringField": &automation.FieldDefinitionArgs{
 * 					IsEncrypted: pulumi.Bool(false),
 * 					IsOptional:  pulumi.Bool(false),
 * 					Type:        pulumi.String("string"),
 * 				},
 * 				"myStringFieldEncrypted": &automation.FieldDefinitionArgs{
 * 					IsEncrypted: pulumi.Bool(true),
 * 					IsOptional:  pulumi.Bool(false),
 * 					Type:        pulumi.String("string"),
 * 				},
 * 			},
 * 			IsGlobal:          pulumi.Bool(false),
 * 			Name:              pulumi.String("myCT"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.ConnectionType;
 * import com.pulumi.azurenative.automation.ConnectionTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionType = new ConnectionType("connectionType", ConnectionTypeArgs.builder()
 *             .automationAccountName("myAutomationAccount22")
 *             .connectionTypeName("myCT")
 *             .fieldDefinitions(Map.ofEntries(
 *                 Map.entry("myBoolField", Map.ofEntries(
 *                     Map.entry("isEncrypted", false),
 *                     Map.entry("isOptional", false),
 *                     Map.entry("type", "bool")
 *                 )),
 *                 Map.entry("myStringField", Map.ofEntries(
 *                     Map.entry("isEncrypted", false),
 *                     Map.entry("isOptional", false),
 *                     Map.entry("type", "string")
 *                 )),
 *                 Map.entry("myStringFieldEncrypted", Map.ofEntries(
 *                     Map.entry("isEncrypted", true),
 *                     Map.entry("isOptional", false),
 *                     Map.entry("type", "string")
 *                 ))
 *             ))
 *             .isGlobal(false)
 *             .name("myCT")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:ConnectionType myCT /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/connectionTypes/{connectionTypeName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property connectionTypeName The parameters supplied to the create or update connection type operation.
 * @property fieldDefinitions Gets or sets the field definitions of the connection type.
 * @property isGlobal Gets or sets a Boolean value to indicate if the connection type is global.
 * @property name Gets or sets the name of the connection type.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class ConnectionTypeArgs(
    public val automationAccountName: Output<String>? = null,
    public val connectionTypeName: Output<String>? = null,
    public val fieldDefinitions: Output<Map<String, FieldDefinitionArgs>>? = null,
    public val isGlobal: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.ConnectionTypeArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.ConnectionTypeArgs =
        com.pulumi.azurenative.automation.ConnectionTypeArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .connectionTypeName(connectionTypeName?.applyValue({ args0 -> args0 }))
            .fieldDefinitions(
                fieldDefinitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .isGlobal(isGlobal?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionTypeArgs].
 */
@PulumiTagMarker
public class ConnectionTypeArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var connectionTypeName: Output<String>? = null

    private var fieldDefinitions: Output<Map<String, FieldDefinitionArgs>>? = null

    private var isGlobal: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("yppsmjelhebglfow")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value The parameters supplied to the create or update connection type operation.
     */
    @JvmName("okdoslelnmhwyspx")
    public suspend fun connectionTypeName(`value`: Output<String>) {
        this.connectionTypeName = value
    }

    /**
     * @param value Gets or sets the field definitions of the connection type.
     */
    @JvmName("lalngdwlbfwxhmrb")
    public suspend fun fieldDefinitions(`value`: Output<Map<String, FieldDefinitionArgs>>) {
        this.fieldDefinitions = value
    }

    /**
     * @param value Gets or sets a Boolean value to indicate if the connection type is global.
     */
    @JvmName("bjbbldprvhuckpho")
    public suspend fun isGlobal(`value`: Output<Boolean>) {
        this.isGlobal = value
    }

    /**
     * @param value Gets or sets the name of the connection type.
     */
    @JvmName("mdxrcwpudjqxlkrs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("pvweunbxkpvakigk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("ufdvxdpendtgjaoj")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value The parameters supplied to the create or update connection type operation.
     */
    @JvmName("olbryjvdbwbbpvaj")
    public suspend fun connectionTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionTypeName = mapped
    }

    /**
     * @param value Gets or sets the field definitions of the connection type.
     */
    @JvmName("vihowjnarffqqqiv")
    public suspend fun fieldDefinitions(`value`: Map<String, FieldDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldDefinitions = mapped
    }

    /**
     * @param argument Gets or sets the field definitions of the connection type.
     */
    @JvmName("hhjhrjscqohyfpyj")
    public suspend fun fieldDefinitions(
        vararg
        argument: Pair<String, suspend FieldDefinitionArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                FieldDefinitionArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.fieldDefinitions = mapped
    }

    /**
     * @param values Gets or sets the field definitions of the connection type.
     */
    @JvmName("okusakpjrbalggkj")
    public fun fieldDefinitions(vararg values: Pair<String, FieldDefinitionArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldDefinitions = mapped
    }

    /**
     * @param value Gets or sets a Boolean value to indicate if the connection type is global.
     */
    @JvmName("slhiuhxuiahctyqs")
    public suspend fun isGlobal(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isGlobal = mapped
    }

    /**
     * @param value Gets or sets the name of the connection type.
     */
    @JvmName("wagjthjcrpjioukh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("tbvsbvuidfeoqwls")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ConnectionTypeArgs = ConnectionTypeArgs(
        automationAccountName = automationAccountName,
        connectionTypeName = connectionTypeName,
        fieldDefinitions = fieldDefinitions,
        isGlobal = isGlobal,
        name = name,
        resourceGroupName = resourceGroupName,
    )
}
