@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.JobScheduleArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.RunbookAssociationPropertyArgs
import com.pulumi.azurenative.automation.kotlin.inputs.RunbookAssociationPropertyArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.ScheduleAssociationPropertyArgs
import com.pulumi.azurenative.automation.kotlin.inputs.ScheduleAssociationPropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the job schedule.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create a job schedule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobSchedule = new AzureNative.Automation.JobSchedule("jobSchedule", new()
 *     {
 *         AutomationAccountName = "ContoseAutomationAccount",
 *         JobScheduleId = "0fa462ba-3aa2-4138-83ca-9ebc3bc55cdc",
 *         Parameters =
 *         {
 *             { "jobscheduletag01", "jobschedulevalue01" },
 *             { "jobscheduletag02", "jobschedulevalue02" },
 *         },
 *         ResourceGroupName = "rg",
 *         Runbook = new AzureNative.Automation.Inputs.RunbookAssociationPropertyArgs
 *         {
 *             Name = "TestRunbook",
 *         },
 *         Schedule = new AzureNative.Automation.Inputs.ScheduleAssociationPropertyArgs
 *         {
 *             Name = "ScheduleNameGoesHere332204b5-debe-4348-a5c7-6357457189f2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewJobSchedule(ctx, "jobSchedule", &automation.JobScheduleArgs{
 * 			AutomationAccountName: pulumi.String("ContoseAutomationAccount"),
 * 			JobScheduleId:         pulumi.String("0fa462ba-3aa2-4138-83ca-9ebc3bc55cdc"),
 * 			Parameters: pulumi.StringMap{
 * 				"jobscheduletag01": pulumi.String("jobschedulevalue01"),
 * 				"jobscheduletag02": pulumi.String("jobschedulevalue02"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			Runbook: &automation.RunbookAssociationPropertyArgs{
 * 				Name: pulumi.String("TestRunbook"),
 * 			},
 * 			Schedule: &automation.ScheduleAssociationPropertyArgs{
 * 				Name: pulumi.String("ScheduleNameGoesHere332204b5-debe-4348-a5c7-6357457189f2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.JobSchedule;
 * import com.pulumi.azurenative.automation.JobScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobSchedule = new JobSchedule("jobSchedule", JobScheduleArgs.builder()
 *             .automationAccountName("ContoseAutomationAccount")
 *             .jobScheduleId("0fa462ba-3aa2-4138-83ca-9ebc3bc55cdc")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("jobscheduletag01", "jobschedulevalue01"),
 *                 Map.entry("jobscheduletag02", "jobschedulevalue02")
 *             ))
 *             .resourceGroupName("rg")
 *             .runbook(Map.of("name", "TestRunbook"))
 *             .schedule(Map.of("name", "ScheduleNameGoesHere332204b5-debe-4348-a5c7-6357457189f2"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:JobSchedule myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/jobSchedules/{jobScheduleId}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property jobScheduleId The job schedule name.
 * @property parameters Gets or sets a list of job properties.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property runOn Gets or sets the hybrid worker group that the scheduled job should run on.
 * @property runbook Gets or sets the runbook.
 * @property schedule Gets or sets the schedule.
 */
public data class JobScheduleArgs(
    public val automationAccountName: Output<String>? = null,
    public val jobScheduleId: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runOn: Output<String>? = null,
    public val runbook: Output<RunbookAssociationPropertyArgs>? = null,
    public val schedule: Output<ScheduleAssociationPropertyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.JobScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.JobScheduleArgs =
        com.pulumi.azurenative.automation.JobScheduleArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .jobScheduleId(jobScheduleId?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runOn(runOn?.applyValue({ args0 -> args0 }))
            .runbook(runbook?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JobScheduleArgs].
 */
@PulumiTagMarker
public class JobScheduleArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var jobScheduleId: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var runOn: Output<String>? = null

    private var runbook: Output<RunbookAssociationPropertyArgs>? = null

    private var schedule: Output<ScheduleAssociationPropertyArgs>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("llcvspxslvoiglvt")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value The job schedule name.
     */
    @JvmName("jkchgbgctylrqvpd")
    public suspend fun jobScheduleId(`value`: Output<String>) {
        this.jobScheduleId = value
    }

    /**
     * @param value Gets or sets a list of job properties.
     */
    @JvmName("ekpdsohlsnhjtmke")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("dsyudymugafjbvsf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the hybrid worker group that the scheduled job should run on.
     */
    @JvmName("hppdbipruqbcscvf")
    public suspend fun runOn(`value`: Output<String>) {
        this.runOn = value
    }

    /**
     * @param value Gets or sets the runbook.
     */
    @JvmName("fedkxphkgjdubgar")
    public suspend fun runbook(`value`: Output<RunbookAssociationPropertyArgs>) {
        this.runbook = value
    }

    /**
     * @param value Gets or sets the schedule.
     */
    @JvmName("jduxgaowvnlmbhwi")
    public suspend fun schedule(`value`: Output<ScheduleAssociationPropertyArgs>) {
        this.schedule = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("dtbkrhoqxxtocrxf")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value The job schedule name.
     */
    @JvmName("yvvcmlmvjplleldc")
    public suspend fun jobScheduleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobScheduleId = mapped
    }

    /**
     * @param value Gets or sets a list of job properties.
     */
    @JvmName("elouvsbhtbrbroce")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Gets or sets a list of job properties.
     */
    @JvmName("pbtuudaedfvykqvo")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("pciltwveutmvqnep")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the hybrid worker group that the scheduled job should run on.
     */
    @JvmName("nmrrvpgwaislllcd")
    public suspend fun runOn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runOn = mapped
    }

    /**
     * @param value Gets or sets the runbook.
     */
    @JvmName("ayjofvqvkahkjjcp")
    public suspend fun runbook(`value`: RunbookAssociationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runbook = mapped
    }

    /**
     * @param argument Gets or sets the runbook.
     */
    @JvmName("xhrsqytujqjhxgnc")
    public suspend fun runbook(argument: suspend RunbookAssociationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = RunbookAssociationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.runbook = mapped
    }

    /**
     * @param value Gets or sets the schedule.
     */
    @JvmName("jqvvheaqiotttldn")
    public suspend fun schedule(`value`: ScheduleAssociationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Gets or sets the schedule.
     */
    @JvmName("ybymsysaxgbtrcyq")
    public suspend fun schedule(argument: suspend ScheduleAssociationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduleAssociationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    internal fun build(): JobScheduleArgs = JobScheduleArgs(
        automationAccountName = automationAccountName,
        jobScheduleId = jobScheduleId,
        parameters = parameters,
        resourceGroupName = resourceGroupName,
        runOn = runOn,
        runbook = runbook,
        schedule = schedule,
    )
}
