@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.ContentLinkResponse
import com.pulumi.azurenative.automation.kotlin.outputs.PackageErrorInfoResponse
import com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.automation.kotlin.outputs.ContentLinkResponse.Companion.toKotlin as contentLinkResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.PackageErrorInfoResponse.Companion.toKotlin as packageErrorInfoResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Package].
 */
@PulumiTagMarker
public class PackageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PackageArgs = PackageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PackageArgsBuilder.() -> Unit) {
        val builder = PackageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Package {
        val builtJavaResource = com.pulumi.azurenative.automation.Package(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Package(builtJavaResource)
    }
}

/**
 * Definition of the Package type.
 * Azure REST API version: 2023-05-15-preview.
 * ## Example Usage
 * ### Create or update a package
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var package = new AzureNative.Automation.Package("package", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount33",
 *         ContentLink = new AzureNative.Automation.Inputs.ContentLinkArgs
 *         {
 *             ContentHash = new AzureNative.Automation.Inputs.ContentHashArgs
 *             {
 *                 Algorithm = "sha265",
 *                 Value = "07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A",
 *             },
 *             Uri = "https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip",
 *         },
 *         PackageName = "OmsCompositeResources",
 *         ResourceGroupName = "rg",
 *         RuntimeEnvironmentName = "runtimeEnvironmentName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewPackage(ctx, "package", &automation.PackageArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount33"),
 * 			ContentLink: automation.ContentLinkResponse{
 * 				ContentHash: &automation.ContentHashArgs{
 * 					Algorithm: pulumi.String("sha265"),
 * 					Value:     pulumi.String("07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A"),
 * 				},
 * 				Uri: pulumi.String("https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip"),
 * 			},
 * 			PackageName:            pulumi.String("OmsCompositeResources"),
 * 			ResourceGroupName:      pulumi.String("rg"),
 * 			RuntimeEnvironmentName: pulumi.String("runtimeEnvironmentName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Package;
 * import com.pulumi.azurenative.automation.PackageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var package_ = new Package("package", PackageArgs.builder()
 *             .automationAccountName("myAutomationAccount33")
 *             .contentLink(Map.ofEntries(
 *                 Map.entry("contentHash", Map.ofEntries(
 *                     Map.entry("algorithm", "sha265"),
 *                     Map.entry("value", "07E108A962B81DD9C9BAA89BB47C0F6EE52B29E83758B07795E408D258B2B87A")
 *                 )),
 *                 Map.entry("uri", "https://teststorage.blob.core.windows.net/dsccomposite/OmsCompositeResources.zip")
 *             ))
 *             .packageName("OmsCompositeResources")
 *             .resourceGroupName("rg")
 *             .runtimeEnvironmentName("runtimeEnvironmentName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Package OmsCompositeResources /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runtimeEnvironments/{runtimeEnvironmentName}/packages/{packageName}
 * ```
 */
public class Package internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.Package,
) : KotlinCustomResource(javaResource, PackageMapper) {
    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val allOf: Output<SystemDataResponse>
        get() = javaResource.allOf().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the contentLink of the Package.
     */
    public val contentLink: Output<ContentLinkResponse>?
        get() = javaResource.contentLink().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    contentLinkResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the isGlobal flag of the package.
     */
    public val default: Output<Boolean>?
        get() = javaResource.default_().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the error info of the Package.
     */
    public val error: Output<PackageErrorInfoResponse>?
        get() = javaResource.error().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    packageErrorInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the provisioning state of the Package.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the size in bytes of the Package.
     */
    public val sizeInBytes: Output<Double>?
        get() = javaResource.sizeInBytes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the version of the Package.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object PackageMapper : ResourceMapper<Package> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.Package::class == javaResource::class

    override fun map(javaResource: Resource): Package = Package(
        javaResource as
            com.pulumi.azurenative.automation.Package,
    )
}

/**
 * @see [Package].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Package].
 */
public suspend fun `package`(name: String, block: suspend PackageResourceBuilder.() -> Unit):
    Package {
    val builder = PackageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Package].
 * @param name The _unique_ name of the resulting resource.
 */
public fun `package`(name: String): Package {
    val builder = PackageResourceBuilder()
    builder.name(name)
    return builder.build()
}
