@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.ContentLinkResponse
import com.pulumi.azurenative.automation.kotlin.outputs.RunbookDraftResponse
import com.pulumi.azurenative.automation.kotlin.outputs.RunbookParameterResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.automation.kotlin.outputs.ContentLinkResponse.Companion.toKotlin as contentLinkResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.RunbookDraftResponse.Companion.toKotlin as runbookDraftResponseToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.RunbookParameterResponse.Companion.toKotlin as runbookParameterResponseToKotlin

/**
 * Builder for [Runbook].
 */
@PulumiTagMarker
public class RunbookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RunbookArgs = RunbookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RunbookArgsBuilder.() -> Unit) {
        val builder = RunbookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Runbook {
        val builtJavaResource = com.pulumi.azurenative.automation.Runbook(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Runbook(builtJavaResource)
    }
}

/**
 * Definition of the runbook type.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update runbook and publish it
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var runbook = new AzureNative.Automation.Runbook("runbook", new()
 *     {
 *         AutomationAccountName = "ContoseAutomationAccount",
 *         Description = "Description of the Runbook",
 *         Location = "East US 2",
 *         LogActivityTrace = 1,
 *         LogProgress = true,
 *         LogVerbose = false,
 *         Name = "Get-AzureVMTutorial",
 *         PublishContentLink = new AzureNative.Automation.Inputs.ContentLinkArgs
 *         {
 *             ContentHash = new AzureNative.Automation.Inputs.ContentHashArgs
 *             {
 *                 Algorithm = "SHA256",
 *                 Value = "115775B8FF2BE672D8A946BD0B489918C724DDE15A440373CA54461D53010A80",
 *             },
 *             Uri = "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/master/101-automation-runbook-getvms/Runbooks/Get-AzureVMTutorial.ps1",
 *         },
 *         ResourceGroupName = "rg",
 *         RunbookName = "Get-AzureVMTutorial",
 *         RunbookType = "PowerShellWorkflow",
 *         Tags =
 *         {
 *             { "tag01", "value01" },
 *             { "tag02", "value02" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewRunbook(ctx, "runbook", &automation.RunbookArgs{
 * 			AutomationAccountName: pulumi.String("ContoseAutomationAccount"),
 * 			Description:           pulumi.String("Description of the Runbook"),
 * 			Location:              pulumi.String("East US 2"),
 * 			LogActivityTrace:      pulumi.Int(1),
 * 			LogProgress:           pulumi.Bool(true),
 * 			LogVerbose:            pulumi.Bool(false),
 * 			Name:                  pulumi.String("Get-AzureVMTutorial"),
 * 			PublishContentLink: automation.ContentLinkResponse{
 * 				ContentHash: &automation.ContentHashArgs{
 * 					Algorithm: pulumi.String("SHA256"),
 * 					Value:     pulumi.String("115775B8FF2BE672D8A946BD0B489918C724DDE15A440373CA54461D53010A80"),
 * 				},
 * 				Uri: pulumi.String("https://raw.githubusercontent.com/Azure/azure-quickstart-templates/master/101-automation-runbook-getvms/Runbooks/Get-AzureVMTutorial.ps1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			RunbookName:       pulumi.String("Get-AzureVMTutorial"),
 * 			RunbookType:       pulumi.String("PowerShellWorkflow"),
 * 			Tags: pulumi.StringMap{
 * 				"tag01": pulumi.String("value01"),
 * 				"tag02": pulumi.String("value02"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Runbook;
 * import com.pulumi.azurenative.automation.RunbookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var runbook = new Runbook("runbook", RunbookArgs.builder()
 *             .automationAccountName("ContoseAutomationAccount")
 *             .description("Description of the Runbook")
 *             .location("East US 2")
 *             .logActivityTrace(1)
 *             .logProgress(true)
 *             .logVerbose(false)
 *             .name("Get-AzureVMTutorial")
 *             .publishContentLink(Map.ofEntries(
 *                 Map.entry("contentHash", Map.ofEntries(
 *                     Map.entry("algorithm", "SHA256"),
 *                     Map.entry("value", "115775B8FF2BE672D8A946BD0B489918C724DDE15A440373CA54461D53010A80")
 *                 )),
 *                 Map.entry("uri", "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/master/101-automation-runbook-getvms/Runbooks/Get-AzureVMTutorial.ps1")
 *             ))
 *             .resourceGroupName("rg")
 *             .runbookName("Get-AzureVMTutorial")
 *             .runbookType("PowerShellWorkflow")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag01", "value01"),
 *                 Map.entry("tag02", "value02")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create runbook as draft
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var runbook = new AzureNative.Automation.Runbook("runbook", new()
 *     {
 *         AutomationAccountName = "ContoseAutomationAccount",
 *         Description = "Description of the Runbook",
 *         Draft = null,
 *         Location = "East US 2",
 *         LogProgress = false,
 *         LogVerbose = false,
 *         Name = "Get-AzureVMTutorial",
 *         ResourceGroupName = "rg",
 *         RunbookName = "Get-AzureVMTutorial",
 *         RunbookType = "PowerShellWorkflow",
 *         Tags =
 *         {
 *             { "tag01", "value01" },
 *             { "tag02", "value02" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewRunbook(ctx, "runbook", &automation.RunbookArgs{
 * 			AutomationAccountName: pulumi.String("ContoseAutomationAccount"),
 * 			Description:           pulumi.String("Description of the Runbook"),
 * 			Draft:                 nil,
 * 			Location:              pulumi.String("East US 2"),
 * 			LogProgress:           pulumi.Bool(false),
 * 			LogVerbose:            pulumi.Bool(false),
 * 			Name:                  pulumi.String("Get-AzureVMTutorial"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			RunbookName:           pulumi.String("Get-AzureVMTutorial"),
 * 			RunbookType:           pulumi.String("PowerShellWorkflow"),
 * 			Tags: pulumi.StringMap{
 * 				"tag01": pulumi.String("value01"),
 * 				"tag02": pulumi.String("value02"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Runbook;
 * import com.pulumi.azurenative.automation.RunbookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var runbook = new Runbook("runbook", RunbookArgs.builder()
 *             .automationAccountName("ContoseAutomationAccount")
 *             .description("Description of the Runbook")
 *             .draft()
 *             .location("East US 2")
 *             .logProgress(false)
 *             .logVerbose(false)
 *             .name("Get-AzureVMTutorial")
 *             .resourceGroupName("rg")
 *             .runbookName("Get-AzureVMTutorial")
 *             .runbookType("PowerShellWorkflow")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag01", "value01"),
 *                 Map.entry("tag02", "value02")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Runbook Get-AzureVMTutorial /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}
 * ```
 */
public class Runbook internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.Runbook,
) : KotlinCustomResource(javaResource, RunbookMapper) {
    /**
     * Gets or sets the creation time.
     */
    public val creationTime: Output<String>?
        get() = javaResource.creationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the draft runbook properties.
     */
    public val draft: Output<RunbookDraftResponse>?
        get() = javaResource.draft().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    runbookDraftResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the etag of the resource.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the job count of the runbook.
     */
    public val jobCount: Output<Int>?
        get() = javaResource.jobCount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the last modified by.
     */
    public val lastModifiedBy: Output<String>?
        get() = javaResource.lastModifiedBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the last modified time.
     */
    public val lastModifiedTime: Output<String>?
        get() = javaResource.lastModifiedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Azure Region where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the option to log activity trace of the runbook.
     */
    public val logActivityTrace: Output<Int>?
        get() = javaResource.logActivityTrace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets progress log option.
     */
    public val logProgress: Output<Boolean>?
        get() = javaResource.logProgress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets verbose log option.
     */
    public val logVerbose: Output<Boolean>?
        get() = javaResource.logVerbose().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the runbook output types.
     */
    public val outputTypes: Output<List<String>>?
        get() = javaResource.outputTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the runbook parameters.
     */
    public val parameters: Output<Map<String, RunbookParameterResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            runbookParameterResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the provisioning state of the runbook.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the published runbook content link.
     */
    public val publishContentLink: Output<ContentLinkResponse>?
        get() = javaResource.publishContentLink().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> contentLinkResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets or sets the type of the runbook.
     */
    public val runbookType: Output<String>?
        get() = javaResource.runbookType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the state of the runbook.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RunbookMapper : ResourceMapper<Runbook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.Runbook::class == javaResource::class

    override fun map(javaResource: Resource): Runbook = Runbook(
        javaResource as
            com.pulumi.azurenative.automation.Runbook,
    )
}

/**
 * @see [Runbook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Runbook].
 */
public suspend fun runbook(name: String, block: suspend RunbookResourceBuilder.() -> Unit):
    Runbook {
    val builder = RunbookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Runbook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun runbook(name: String): Runbook {
    val builder = RunbookResourceBuilder()
    builder.name(name)
    return builder.build()
}
