@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.WatcherArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the watcher type.
 * Azure REST API version: 2020-01-13-preview. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview.
 * ## Example Usage
 * ### Create or update watcher
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var watcher = new AzureNative.Automation.Watcher("watcher", new()
 *     {
 *         AutomationAccountName = "MyTestAutomationAccount",
 *         Description = "This is a test watcher.",
 *         ExecutionFrequencyInSeconds = 60,
 *         ResourceGroupName = "rg",
 *         ScriptName = "MyTestWatcherRunbook",
 *         ScriptRunOn = "MyTestHybridWorkerGroup",
 *         Tags = null,
 *         WatcherName = "MyTestWatcher",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewWatcher(ctx, "watcher", &automation.WatcherArgs{
 * 			AutomationAccountName:       pulumi.String("MyTestAutomationAccount"),
 * 			Description:                 pulumi.String("This is a test watcher."),
 * 			ExecutionFrequencyInSeconds: pulumi.Float64(60),
 * 			ResourceGroupName:           pulumi.String("rg"),
 * 			ScriptName:                  pulumi.String("MyTestWatcherRunbook"),
 * 			ScriptRunOn:                 pulumi.String("MyTestHybridWorkerGroup"),
 * 			Tags:                        nil,
 * 			WatcherName:                 pulumi.String("MyTestWatcher"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Watcher;
 * import com.pulumi.azurenative.automation.WatcherArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var watcher = new Watcher("watcher", WatcherArgs.builder()
 *             .automationAccountName("MyTestAutomationAccount")
 *             .description("This is a test watcher.")
 *             .executionFrequencyInSeconds(60)
 *             .resourceGroupName("rg")
 *             .scriptName("MyTestWatcherRunbook")
 *             .scriptRunOn("MyTestHybridWorkerGroup")
 *             .tags()
 *             .watcherName("MyTestWatcher")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Watcher MyTestWatcher /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/watchers/{watcherName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property description Gets or sets the description.
 * @property executionFrequencyInSeconds Gets or sets the frequency at which the watcher is invoked.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName Name of an Azure Resource group.
 * @property scriptName Gets or sets the name of the script the watcher is attached to, i.e. the name of an existing runbook.
 * @property scriptParameters Gets or sets the parameters of the script.
 * @property scriptRunOn Gets or sets the name of the hybrid worker group the watcher will run on.
 * @property tags Resource tags.
 * @property watcherName The watcher name.
 */
public data class WatcherArgs(
    public val automationAccountName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val executionFrequencyInSeconds: Output<Double>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scriptName: Output<String>? = null,
    public val scriptParameters: Output<Map<String, String>>? = null,
    public val scriptRunOn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val watcherName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.WatcherArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.WatcherArgs =
        com.pulumi.azurenative.automation.WatcherArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .executionFrequencyInSeconds(executionFrequencyInSeconds?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scriptName(scriptName?.applyValue({ args0 -> args0 }))
            .scriptParameters(
                scriptParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .scriptRunOn(scriptRunOn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .watcherName(watcherName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WatcherArgs].
 */
@PulumiTagMarker
public class WatcherArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var description: Output<String>? = null

    private var executionFrequencyInSeconds: Output<Double>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scriptName: Output<String>? = null

    private var scriptParameters: Output<Map<String, String>>? = null

    private var scriptRunOn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var watcherName: Output<String>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("lgpcuggouflcdyun")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Gets or sets the description.
     */
    @JvmName("klmhvotdgcflvxjb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the frequency at which the watcher is invoked.
     */
    @JvmName("orcskfmspgpuhvyw")
    public suspend fun executionFrequencyInSeconds(`value`: Output<Double>) {
        this.executionFrequencyInSeconds = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ujgrrfjhvgjlsahh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("loxxdmhtyenseutw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the name of the script the watcher is attached to, i.e. the name of an existing runbook.
     */
    @JvmName("xgpmvbxcsvfyelel")
    public suspend fun scriptName(`value`: Output<String>) {
        this.scriptName = value
    }

    /**
     * @param value Gets or sets the parameters of the script.
     */
    @JvmName("resoghcibvogtsnl")
    public suspend fun scriptParameters(`value`: Output<Map<String, String>>) {
        this.scriptParameters = value
    }

    /**
     * @param value Gets or sets the name of the hybrid worker group the watcher will run on.
     */
    @JvmName("hwsnavpdiaccstqk")
    public suspend fun scriptRunOn(`value`: Output<String>) {
        this.scriptRunOn = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("exjxxqyyukglpity")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The watcher name.
     */
    @JvmName("mrauptlxswoxqnso")
    public suspend fun watcherName(`value`: Output<String>) {
        this.watcherName = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("cqbinihrgvwgxebm")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Gets or sets the description.
     */
    @JvmName("bnkkcbvmxqduyjtv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the frequency at which the watcher is invoked.
     */
    @JvmName("tebpgcskawuyelmp")
    public suspend fun executionFrequencyInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionFrequencyInSeconds = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("talfuwjsumxfxcxp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("exwwsqbsfagfoqml")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the name of the script the watcher is attached to, i.e. the name of an existing runbook.
     */
    @JvmName("dsyyaesqndbkydyb")
    public suspend fun scriptName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptName = mapped
    }

    /**
     * @param value Gets or sets the parameters of the script.
     */
    @JvmName("ramyralcthfiscxh")
    public suspend fun scriptParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptParameters = mapped
    }

    /**
     * @param values Gets or sets the parameters of the script.
     */
    @JvmName("iunaoxpadhphubug")
    public fun scriptParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scriptParameters = mapped
    }

    /**
     * @param value Gets or sets the name of the hybrid worker group the watcher will run on.
     */
    @JvmName("ngfrwgeppipisbja")
    public suspend fun scriptRunOn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptRunOn = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("uspqxitedbbcmhtk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("teonwxbypecbhppg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The watcher name.
     */
    @JvmName("irdfuftutrdnoqsv")
    public suspend fun watcherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.watcherName = mapped
    }

    internal fun build(): WatcherArgs = WatcherArgs(
        automationAccountName = automationAccountName,
        description = description,
        executionFrequencyInSeconds = executionFrequencyInSeconds,
        location = location,
        resourceGroupName = resourceGroupName,
        scriptName = scriptName,
        scriptParameters = scriptParameters,
        scriptRunOn = scriptRunOn,
        tags = tags,
        watcherName = watcherName,
    )
}
