@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the frequency of the schedule.
 */
public enum class ScheduleFrequency(
    public val javaValue: com.pulumi.azurenative.automation.enums.ScheduleFrequency,
) : ConvertibleToJava<com.pulumi.azurenative.automation.enums.ScheduleFrequency> {
    OneTime(com.pulumi.azurenative.automation.enums.ScheduleFrequency.OneTime),
    Day(com.pulumi.azurenative.automation.enums.ScheduleFrequency.Day),
    Hour(com.pulumi.azurenative.automation.enums.ScheduleFrequency.Hour),
    Week(com.pulumi.azurenative.automation.enums.ScheduleFrequency.Week),
    Month(com.pulumi.azurenative.automation.enums.ScheduleFrequency.Month),

    /**
     * The minimum allowed interval for Minute schedules is 15 minutes.
     */
    Minute(com.pulumi.azurenative.automation.enums.ScheduleFrequency.Minute),
    ;

    override fun toJava(): com.pulumi.azurenative.automation.enums.ScheduleFrequency = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.enums.ScheduleFrequency):
            ScheduleFrequency = ScheduleFrequency.values().first { it.javaValue == javaType }
    }
}
