@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The source type. Must be one of VsoGit, VsoTfvc, GitHub, case sensitive.
 */
public enum class SourceType(
    public val javaValue: com.pulumi.azurenative.automation.enums.SourceType,
) : ConvertibleToJava<com.pulumi.azurenative.automation.enums.SourceType> {
    VsoGit(com.pulumi.azurenative.automation.enums.SourceType.VsoGit),
    VsoTfvc(com.pulumi.azurenative.automation.enums.SourceType.VsoTfvc),
    GitHub(com.pulumi.azurenative.automation.enums.SourceType.GitHub),
    ;

    override fun toJava(): com.pulumi.azurenative.automation.enums.SourceType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.enums.SourceType): SourceType =
            SourceType.values().first { it.javaValue == javaType }
    }
}
