@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.AdvancedScheduleMonthlyOccurrenceArgs.builder
import com.pulumi.azurenative.automation.kotlin.enums.ScheduleDay
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the create advanced schedule monthly occurrence.
 * @property day Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
 * @property occurrence Occurrence of the week within the month. Must be between 1 and 5
 */
public data class AdvancedScheduleMonthlyOccurrenceArgs(
    public val day: Output<Either<String, ScheduleDay>>? = null,
    public val occurrence: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.automation.inputs.AdvancedScheduleMonthlyOccurrenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.automation.inputs.AdvancedScheduleMonthlyOccurrenceArgs =
        com.pulumi.azurenative.automation.inputs.AdvancedScheduleMonthlyOccurrenceArgs.builder()
            .day(
                day?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .occurrence(occurrence?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdvancedScheduleMonthlyOccurrenceArgs].
 */
@PulumiTagMarker
public class AdvancedScheduleMonthlyOccurrenceArgsBuilder internal constructor() {
    private var day: Output<Either<String, ScheduleDay>>? = null

    private var occurrence: Output<Int>? = null

    /**
     * @param value Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
     */
    @JvmName("haqawyiubrforjjw")
    public suspend fun day(`value`: Output<Either<String, ScheduleDay>>) {
        this.day = value
    }

    /**
     * @param value Occurrence of the week within the month. Must be between 1 and 5
     */
    @JvmName("lmusubhywqjoymea")
    public suspend fun occurrence(`value`: Output<Int>) {
        this.occurrence = value
    }

    /**
     * @param value Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
     */
    @JvmName("ldeiayanbqfakkxn")
    public suspend fun day(`value`: Either<String, ScheduleDay>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.day = mapped
    }

    /**
     * @param value Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
     */
    @JvmName("lhxtiawrpwqkvghp")
    public fun day(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduleDay>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.day = mapped
    }

    /**
     * @param value Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
     */
    @JvmName("mcymbhobfhpewhvj")
    public fun day(`value`: ScheduleDay) {
        val toBeMapped = Either.ofRight<String, ScheduleDay>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.day = mapped
    }

    /**
     * @param value Occurrence of the week within the month. Must be between 1 and 5
     */
    @JvmName("qpexlkvaebdvffsk")
    public suspend fun occurrence(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.occurrence = mapped
    }

    internal fun build(): AdvancedScheduleMonthlyOccurrenceArgs =
        AdvancedScheduleMonthlyOccurrenceArgs(
            day = day,
            occurrence = occurrence,
        )
}
