@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.DscConfigurationParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of the configuration parameter type.
 * @property defaultValue Gets or sets the default value of parameter.
 * @property isMandatory Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
 * @property position Get or sets the position of the parameter.
 * @property type Gets or sets the type of the parameter.
 */
public data class DscConfigurationParameterArgs(
    public val defaultValue: Output<String>? = null,
    public val isMandatory: Output<Boolean>? = null,
    public val position: Output<Int>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.DscConfigurationParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.DscConfigurationParameterArgs =
        com.pulumi.azurenative.automation.inputs.DscConfigurationParameterArgs.builder()
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .isMandatory(isMandatory?.applyValue({ args0 -> args0 }))
            .position(position?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DscConfigurationParameterArgs].
 */
@PulumiTagMarker
public class DscConfigurationParameterArgsBuilder internal constructor() {
    private var defaultValue: Output<String>? = null

    private var isMandatory: Output<Boolean>? = null

    private var position: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value Gets or sets the default value of parameter.
     */
    @JvmName("ttaiblpwqsocvvld")
    public suspend fun defaultValue(`value`: Output<String>) {
        this.defaultValue = value
    }

    /**
     * @param value Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
     */
    @JvmName("udnnviaeojwvnykm")
    public suspend fun isMandatory(`value`: Output<Boolean>) {
        this.isMandatory = value
    }

    /**
     * @param value Get or sets the position of the parameter.
     */
    @JvmName("okkcymyidxvoyknc")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value Gets or sets the type of the parameter.
     */
    @JvmName("gtriwxkpohwnaolw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the default value of parameter.
     */
    @JvmName("staprfgglhwubmfe")
    public suspend fun defaultValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
     */
    @JvmName("osiyggmyuhujfkyt")
    public suspend fun isMandatory(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isMandatory = mapped
    }

    /**
     * @param value Get or sets the position of the parameter.
     */
    @JvmName("ccuqpfrsfpqgrnwl")
    public suspend fun position(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.position = mapped
    }

    /**
     * @param value Gets or sets the type of the parameter.
     */
    @JvmName("gaglxqyfdladgroc")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DscConfigurationParameterArgs = DscConfigurationParameterArgs(
        defaultValue = defaultValue,
        isMandatory = isMandatory,
        position = position,
        type = type,
    )
}
