@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property connectionName The name of connection.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class GetConnectionPlainArgs(
    public val automationAccountName: String,
    public val connectionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetConnectionPlainArgs =
        com.pulumi.azurenative.automation.inputs.GetConnectionPlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .connectionName(connectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionPlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var connectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("hcauxvthjlutwxcl")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value The name of connection.
     */
    @JvmName("jdtqotrjwrydknua")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("obaomkabdcohqppy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConnectionPlainArgs = GetConnectionPlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
