@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetCredentialPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property credentialName The name of credential.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class GetCredentialPlainArgs(
    public val automationAccountName: String,
    public val credentialName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetCredentialPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetCredentialPlainArgs =
        com.pulumi.azurenative.automation.inputs.GetCredentialPlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .credentialName(credentialName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCredentialPlainArgs].
 */
@PulumiTagMarker
public class GetCredentialPlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var credentialName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("rnqeoffqppuulmur")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value The name of credential.
     */
    @JvmName("uecxjutgjrdfnpku")
    public suspend fun credentialName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.credentialName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("xteiblnqnsnsgqkx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCredentialPlainArgs = GetCredentialPlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        credentialName = credentialName ?: throw PulumiNullFieldException("credentialName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
