@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetPackagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property packageName The Package name.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property runtimeEnvironmentName The name of the Runtime Environment.
 */
public data class GetPackagePlainArgs(
    public val automationAccountName: String,
    public val packageName: String,
    public val resourceGroupName: String,
    public val runtimeEnvironmentName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetPackagePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetPackagePlainArgs =
        com.pulumi.azurenative.automation.inputs.GetPackagePlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .packageName(packageName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .runtimeEnvironmentName(runtimeEnvironmentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPackagePlainArgs].
 */
@PulumiTagMarker
public class GetPackagePlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var packageName: String? = null

    private var resourceGroupName: String? = null

    private var runtimeEnvironmentName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("ccfbhulrcyjyjqbx")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value The Package name.
     */
    @JvmName("dirdyfumnratpvgr")
    public suspend fun packageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packageName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("lfhqqgbqgajsvxit")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Runtime Environment.
     */
    @JvmName("tfbhqcxsbbkvsxwo")
    public suspend fun runtimeEnvironmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.runtimeEnvironmentName = mapped
    }

    internal fun build(): GetPackagePlainArgs = GetPackagePlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        packageName = packageName ?: throw PulumiNullFieldException("packageName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        runtimeEnvironmentName = runtimeEnvironmentName ?: throw
            PulumiNullFieldException("runtimeEnvironmentName"),
    )
}
