@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.GetRunbookPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property runbookName The runbook name.
 */
public data class GetRunbookPlainArgs(
    public val automationAccountName: String,
    public val resourceGroupName: String,
    public val runbookName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.GetRunbookPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.GetRunbookPlainArgs =
        com.pulumi.azurenative.automation.inputs.GetRunbookPlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .runbookName(runbookName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRunbookPlainArgs].
 */
@PulumiTagMarker
public class GetRunbookPlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var resourceGroupName: String? = null

    private var runbookName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("xldjyidhlrptwpqu")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("mmnycxvpsudortvo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The runbook name.
     */
    @JvmName("qsqyhunrxlxxyayi")
    public suspend fun runbookName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.runbookName = mapped
    }

    internal fun build(): GetRunbookPlainArgs = GetRunbookPlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        runbookName = runbookName ?: throw PulumiNullFieldException("runbookName"),
    )
}
