@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.ListKeyByAutomationAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automationAccountName The name of the automation account.
 * @property resourceGroupName Name of an Azure Resource group.
 */
public data class ListKeyByAutomationAccountPlainArgs(
    public val automationAccountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.ListKeyByAutomationAccountPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.automation.inputs.ListKeyByAutomationAccountPlainArgs =
        com.pulumi.azurenative.automation.inputs.ListKeyByAutomationAccountPlainArgs.builder()
            .automationAccountName(automationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListKeyByAutomationAccountPlainArgs].
 */
@PulumiTagMarker
public class ListKeyByAutomationAccountPlainArgsBuilder internal constructor() {
    private var automationAccountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("hjpttbbveoaxqack")
    public suspend fun automationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.automationAccountName = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("pdwdcbejdkqalbdx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListKeyByAutomationAccountPlainArgs = ListKeyByAutomationAccountPlainArgs(
        automationAccountName = automationAccountName ?: throw
            PulumiNullFieldException("automationAccountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
