@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.TaskPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Task properties of the software update configuration.
 * @property parameters Gets or sets the parameters of the task.
 * @property source Gets or sets the name of the runbook.
 */
public data class TaskPropertiesArgs(
    public val parameters: Output<Map<String, String>>? = null,
    public val source: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.TaskPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.TaskPropertiesArgs =
        com.pulumi.azurenative.automation.inputs.TaskPropertiesArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .source(source?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskPropertiesArgs].
 */
@PulumiTagMarker
public class TaskPropertiesArgsBuilder internal constructor() {
    private var parameters: Output<Map<String, String>>? = null

    private var source: Output<String>? = null

    /**
     * @param value Gets or sets the parameters of the task.
     */
    @JvmName("tvagthoaqgjkpjsu")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Gets or sets the name of the runbook.
     */
    @JvmName("sqroedooknqjrgxu")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Gets or sets the parameters of the task.
     */
    @JvmName("fwxnsybbewvmpndi")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Gets or sets the parameters of the task.
     */
    @JvmName("jocsmafnsmgbcyqx")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Gets or sets the name of the runbook.
     */
    @JvmName("achdgjvdsibeqouo")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): TaskPropertiesArgs = TaskPropertiesArgs(
        parameters = parameters,
        source = source,
    )
}
