@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.inputs

import com.pulumi.azurenative.automation.inputs.TrackedResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'
 * @property location The geo-location where the resource lives
 * @property tags Resource tags.
 */
public data class TrackedResourceArgs(
    public val location: Output<String>,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.inputs.TrackedResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.inputs.TrackedResourceArgs =
        com.pulumi.azurenative.automation.inputs.TrackedResourceArgs.builder()
            .location(location.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TrackedResourceArgs].
 */
@PulumiTagMarker
public class TrackedResourceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("acubsgecmhqvbest")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gvvekwpiwtpjitbq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qmhlwmtteysrkpwq")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rjedkqxxtcgtydof")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("miyldvfcycjcnorc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TrackedResourceArgs = TrackedResourceArgs(
        location = location ?: throw PulumiNullFieldException("location"),
        tags = tags,
    )
}
