@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of deleted runbook.
 * @property creationTime Gets or sets the creation time.
 * @property deletionTime Gets or sets the last modified time.
 * @property id The resource id.
 * @property location Gets or sets the location of the resource.
 * @property name Gets or sets name of the resource.
 * @property runbookId Gets or sets the Runbook Id.
 * @property runbookType Type of the runbook.
 * @property runtime Gets or sets runtime of the runbook.
 * @property runtimeEnvironment Environment of the runbook.
 */
public data class DeletedRunbookResponse(
    public val creationTime: String? = null,
    public val deletionTime: String? = null,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String? = null,
    public val runbookId: String? = null,
    public val runbookType: String? = null,
    public val runtime: String? = null,
    public val runtimeEnvironment: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.DeletedRunbookResponse):
            DeletedRunbookResponse = DeletedRunbookResponse(
            creationTime = javaType.creationTime().map({ args0 -> args0 }).orElse(null),
            deletionTime = javaType.deletionTime().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            runbookId = javaType.runbookId().map({ args0 -> args0 }).orElse(null),
            runbookType = javaType.runbookType().map({ args0 -> args0 }).orElse(null),
            runtime = javaType.runtime().map({ args0 -> args0 }).orElse(null),
            runtimeEnvironment = javaType.runtimeEnvironment().map({ args0 -> args0 }).orElse(null),
        )
    }
}
