@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The encryption settings for automation account
 * @property identity User identity used for CMK.
 * @property keySource Encryption Key Source
 * @property keyVaultProperties Key vault properties.
 */
public data class EncryptionPropertiesResponse(
    public val identity: EncryptionPropertiesResponseIdentity? = null,
    public val keySource: String? = null,
    public val keyVaultProperties: KeyVaultPropertiesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.EncryptionPropertiesResponse):
            EncryptionPropertiesResponse = EncryptionPropertiesResponse(
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.EncryptionPropertiesResponseIdentity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keySource = javaType.keySource().map({ args0 -> args0 }).orElse(null),
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
