@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Automation key which is used to register a DSC Node
 * @property keyName Automation key name.
 * @property permissions Automation key permissions.
 * @property value Value of the Automation Key used for registration.
 */
public data class KeyResponse(
    public val keyName: String,
    public val permissions: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.KeyResponse):
            KeyResponse = KeyResponse(
            keyName = javaType.keyName(),
            permissions = javaType.permissions(),
            `value` = javaType.`value`(),
        )
    }
}
