@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The response model for the list deleted runbook.
 * @property nextLink Gets or sets the next link.
 * @property value List of deleted runbooks in automation account.
 */
public data class ListAutomationAccountDeletedRunbooksResult(
    public val nextLink: String? = null,
    public val `value`: List<DeletedRunbookResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.ListAutomationAccountDeletedRunbooksResult):
            ListAutomationAccountDeletedRunbooksResult = ListAutomationAccountDeletedRunbooksResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.DeletedRunbookResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
