@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The account SKU.
 * @property capacity Gets or sets the SKU capacity.
 * @property family Gets or sets the SKU family.
 * @property name Gets or sets the SKU name of the account.
 */
public data class SkuResponse(
    public val capacity: Int? = null,
    public val family: String? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.SkuResponse):
            SkuResponse = SkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            family = javaType.family().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
