@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Group specific to the update configuration.
 * @property azureQueries List of Azure queries in the software update configuration.
 * @property nonAzureQueries List of non Azure queries in the software update configuration.
 */
public data class TargetPropertiesResponse(
    public val azureQueries: List<AzureQueryPropertiesResponse>? = null,
    public val nonAzureQueries: List<NonAzureQueryPropertiesResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.automation.outputs.TargetPropertiesResponse):
            TargetPropertiesResponse = TargetPropertiesResponse(
            azureQueries = javaType.azureQueries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.AzureQueryPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            nonAzureQueries = javaType.nonAzureQueries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.automation.kotlin.outputs.NonAzureQueryPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
