@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.autonomousdevelopmentplatform.kotlin.inputs

import com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.DataPoolLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Location of a Data Pool
 * @property encryption Encryption properties of a Data Pool location
 * @property name The location name
 * @property storageAccountCount The amount of storage accounts provisioned per Data Pool. Default: 5
 * @property storageSku The Storage SKU. Default: Standard_ZRS.
 */
public data class DataPoolLocationArgs(
    public val encryption: Output<DataPoolEncryptionArgs>? = null,
    public val name: Output<String>,
    public val storageAccountCount: Output<Int>? = null,
    public val storageSku: Output<StorageSkuArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.DataPoolLocationArgs> {
    override fun toJava():
        com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.DataPoolLocationArgs =
        com.pulumi.azurenative.autonomousdevelopmentplatform.inputs.DataPoolLocationArgs.builder()
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .storageAccountCount(storageAccountCount?.applyValue({ args0 -> args0 }))
            .storageSku(storageSku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataPoolLocationArgs].
 */
@PulumiTagMarker
public class DataPoolLocationArgsBuilder internal constructor() {
    private var encryption: Output<DataPoolEncryptionArgs>? = null

    private var name: Output<String>? = null

    private var storageAccountCount: Output<Int>? = null

    private var storageSku: Output<StorageSkuArgs>? = null

    /**
     * @param value Encryption properties of a Data Pool location
     */
    @JvmName("bucdynngovvdslup")
    public suspend fun encryption(`value`: Output<DataPoolEncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value The location name
     */
    @JvmName("mywhuyosfvrykotj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The amount of storage accounts provisioned per Data Pool. Default: 5
     */
    @JvmName("ditftcwbddhrehgu")
    public suspend fun storageAccountCount(`value`: Output<Int>) {
        this.storageAccountCount = value
    }

    /**
     * @param value The Storage SKU. Default: Standard_ZRS.
     */
    @JvmName("wrfldurpubetcgch")
    public suspend fun storageSku(`value`: Output<StorageSkuArgs>) {
        this.storageSku = value
    }

    /**
     * @param value Encryption properties of a Data Pool location
     */
    @JvmName("arionnihofuqeipq")
    public suspend fun encryption(`value`: DataPoolEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Encryption properties of a Data Pool location
     */
    @JvmName("tdjgunyclipswikr")
    public suspend fun encryption(argument: suspend DataPoolEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = DataPoolEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The location name
     */
    @JvmName("ahjoqvmhmrdqudhj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The amount of storage accounts provisioned per Data Pool. Default: 5
     */
    @JvmName("lorihmvidscmvhxr")
    public suspend fun storageAccountCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountCount = mapped
    }

    /**
     * @param value The Storage SKU. Default: Standard_ZRS.
     */
    @JvmName("wdyxaheqpaiydeoo")
    public suspend fun storageSku(`value`: StorageSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSku = mapped
    }

    /**
     * @param argument The Storage SKU. Default: Standard_ZRS.
     */
    @JvmName("rdlquielxenqmmiu")
    public suspend fun storageSku(argument: suspend StorageSkuArgsBuilder.() -> Unit) {
        val toBeMapped = StorageSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageSku = mapped
    }

    internal fun build(): DataPoolLocationArgs = DataPoolLocationArgs(
        encryption = encryption,
        name = name ?: throw PulumiNullFieldException("name"),
        storageAccountCount = storageAccountCount,
        storageSku = storageSku,
    )
}
