@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.AuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ExpressRoute Circuit Authorization
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-03-20.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### Authorizations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorization = new AzureNative.AVS.Authorization("authorization", new()
 *     {
 *         AuthorizationName = "authorization1",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewAuthorization(ctx, "authorization", &avs.AuthorizationArgs{
 * 			AuthorizationName: pulumi.String("authorization1"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.Authorization;
 * import com.pulumi.azurenative.avs.AuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorization = new Authorization("authorization", AuthorizationArgs.builder()
 *             .authorizationName("authorization1")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:Authorization authorization1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/authorizations/{authorizationName}
 * ```
 * @property authorizationName Name of the ExpressRoute Circuit Authorization in the private cloud
 * @property expressRouteId The ID of the ExpressRoute Circuit
 * @property privateCloudName The name of the private cloud.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class AuthorizationArgs(
    public val authorizationName: Output<String>? = null,
    public val expressRouteId: Output<String>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.AuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.AuthorizationArgs =
        com.pulumi.azurenative.avs.AuthorizationArgs.builder()
            .authorizationName(authorizationName?.applyValue({ args0 -> args0 }))
            .expressRouteId(expressRouteId?.applyValue({ args0 -> args0 }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizationArgs].
 */
@PulumiTagMarker
public class AuthorizationArgsBuilder internal constructor() {
    private var authorizationName: Output<String>? = null

    private var expressRouteId: Output<String>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the ExpressRoute Circuit Authorization in the private cloud
     */
    @JvmName("xeaxvqmavbecncgq")
    public suspend fun authorizationName(`value`: Output<String>) {
        this.authorizationName = value
    }

    /**
     * @param value The ID of the ExpressRoute Circuit
     */
    @JvmName("iicktuwntndvwxjw")
    public suspend fun expressRouteId(`value`: Output<String>) {
        this.expressRouteId = value
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("yxgindreplpdmdje")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sgbiasaqnjnwbhti")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the ExpressRoute Circuit Authorization in the private cloud
     */
    @JvmName("xxecikfqcwjmfwpu")
    public suspend fun authorizationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationName = mapped
    }

    /**
     * @param value The ID of the ExpressRoute Circuit
     */
    @JvmName("gsavpojqjbamqhgf")
    public suspend fun expressRouteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteId = mapped
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("uygrutmdowjswpsp")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cwjekccvimrgnovy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): AuthorizationArgs = AuthorizationArgs(
        authorizationName = authorizationName,
        expressRouteId = expressRouteId,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
    )
}
