@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.ClusterArgs.builder
import com.pulumi.azurenative.avs.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.avs.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A cluster resource
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-03-20.
 * Other available API versions: 2020-03-20, 2021-06-01, 2023-03-01.
 * ## Example Usage
 * ### Clusters_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.AVS.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         ClusterSize = 3,
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Sku = new AzureNative.AVS.Inputs.SkuArgs
 *         {
 *             Name = "AV20",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewCluster(ctx, "cluster", &avs.ClusterArgs{
 * 			ClusterName:       pulumi.String("cluster1"),
 * 			ClusterSize:       pulumi.Int(3),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Sku: &avs.SkuArgs{
 * 				Name: pulumi.String("AV20"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.Cluster;
 * import com.pulumi.azurenative.avs.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .clusterSize(3)
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .sku(Map.of("name", "AV20"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:Cluster cluster1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/clusters/{clusterName}
 * ```
 * @property clusterName Name of the cluster in the private cloud
 * @property clusterSize The cluster size
 * @property hosts The hosts
 * @property privateCloudName The name of the private cloud.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The cluster SKU
 */
public data class ClusterArgs(
    public val clusterName: Output<String>? = null,
    public val clusterSize: Output<Int>? = null,
    public val hosts: Output<List<String>>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.ClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.ClusterArgs =
        com.pulumi.azurenative.avs.ClusterArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .clusterSize(clusterSize?.applyValue({ args0 -> args0 }))
            .hosts(hosts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var clusterSize: Output<Int>? = null

    private var hosts: Output<List<String>>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    /**
     * @param value Name of the cluster in the private cloud
     */
    @JvmName("gvihangqodtlpuso")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The cluster size
     */
    @JvmName("tqxnfnakcnjrcugs")
    public suspend fun clusterSize(`value`: Output<Int>) {
        this.clusterSize = value
    }

    /**
     * @param value The hosts
     */
    @JvmName("kiyovbchxrvpowea")
    public suspend fun hosts(`value`: Output<List<String>>) {
        this.hosts = value
    }

    @JvmName("louiwwcgbppyqjik")
    public suspend fun hosts(vararg values: Output<String>) {
        this.hosts = Output.all(values.asList())
    }

    /**
     * @param values The hosts
     */
    @JvmName("jnlhvdgcosddlymw")
    public suspend fun hosts(values: List<Output<String>>) {
        this.hosts = Output.all(values)
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("mekjtfbmabqnhrbl")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ljckqocaledpdawu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The cluster SKU
     */
    @JvmName("wtusjurlrgikcmts")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Name of the cluster in the private cloud
     */
    @JvmName("bfvjycnwaxgivwgf")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The cluster size
     */
    @JvmName("yiqdiklnkgnqqvaw")
    public suspend fun clusterSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterSize = mapped
    }

    /**
     * @param value The hosts
     */
    @JvmName("bniaiybhdipagbdb")
    public suspend fun hosts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hosts = mapped
    }

    /**
     * @param values The hosts
     */
    @JvmName("ewendkpllublvpct")
    public suspend fun hosts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hosts = mapped
    }

    /**
     * @param value The name of the private cloud.
     */
    @JvmName("ygobofnouyitspej")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("siaspevfsgubxwup")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The cluster SKU
     */
    @JvmName("ypyecgqesxwryure")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The cluster SKU
     */
    @JvmName("sbhrvbxxeekorcrg")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        clusterName = clusterName,
        clusterSize = clusterSize,
        hosts = hosts,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
        sku = sku,
    )
}
