@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.kotlin.outputs.VmHostPlacementPolicyPropertiesResponse
import com.pulumi.azurenative.avs.kotlin.outputs.VmVmPlacementPolicyPropertiesResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PlacementPolicy].
 */
@PulumiTagMarker
public class PlacementPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PlacementPolicyArgs = PlacementPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PlacementPolicyArgsBuilder.() -> Unit) {
        val builder = PlacementPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PlacementPolicy {
        val builtJavaResource = com.pulumi.azurenative.avs.PlacementPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PlacementPolicy(builtJavaResource)
    }
}

/**
 * A vSphere Distributed Resource Scheduler (DRS) placement policy
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2021-12-01.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### PlacementPolicies_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var placementPolicy = new AzureNative.AVS.PlacementPolicy("placementPolicy", new()
 *     {
 *         ClusterName = "cluster1",
 *         PlacementPolicyName = "policy1",
 *         PrivateCloudName = "cloud1",
 *         Properties = new AzureNative.AVS.Inputs.VmHostPlacementPolicyPropertiesArgs
 *         {
 *             AffinityStrength = "Must",
 *             AffinityType = "AntiAffinity",
 *             AzureHybridBenefitType = "SqlHost",
 *             HostMembers = new[]
 *             {
 *                 "fakehost22.nyc1.kubernetes.center",
 *                 "fakehost23.nyc1.kubernetes.center",
 *                 "fakehost24.nyc1.kubernetes.center",
 *             },
 *             Type = "VmHost",
 *             VmMembers = new[]
 *             {
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/clusters/cluster1/virtualMachines/vm-128",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/clusters/cluster1/virtualMachines/vm-256",
 *             },
 *         },
 *         ResourceGroupName = "group1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewPlacementPolicy(ctx, "placementPolicy", &avs.PlacementPolicyArgs{
 * 			ClusterName:         pulumi.String("cluster1"),
 * 			PlacementPolicyName: pulumi.String("policy1"),
 * 			PrivateCloudName:    pulumi.String("cloud1"),
 * 			Properties: avs.VmHostPlacementPolicyProperties{
 * 				AffinityStrength:       "Must",
 * 				AffinityType:           "AntiAffinity",
 * 				AzureHybridBenefitType: "SqlHost",
 * 				HostMembers: []string{
 * 					"fakehost22.nyc1.kubernetes.center",
 * 					"fakehost23.nyc1.kubernetes.center",
 * 					"fakehost24.nyc1.kubernetes.center",
 * 				},
 * 				Type: "VmHost",
 * 				VmMembers: []string{
 * 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/clusters/cluster1/virtualMachines/vm-128",
 * 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/clusters/cluster1/virtualMachines/vm-256",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.PlacementPolicy;
 * import com.pulumi.azurenative.avs.PlacementPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var placementPolicy = new PlacementPolicy("placementPolicy", PlacementPolicyArgs.builder()
 *             .clusterName("cluster1")
 *             .placementPolicyName("policy1")
 *             .privateCloudName("cloud1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("affinityStrength", "Must"),
 *                 Map.entry("affinityType", "AntiAffinity"),
 *                 Map.entry("azureHybridBenefitType", "SqlHost"),
 *                 Map.entry("hostMembers",
 *                     "fakehost22.nyc1.kubernetes.center",
 *                     "fakehost23.nyc1.kubernetes.center",
 *                     "fakehost24.nyc1.kubernetes.center"),
 *                 Map.entry("type", "VmHost"),
 *                 Map.entry("vmMembers",
 *                     "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/clusters/cluster1/virtualMachines/vm-128",
 *                     "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/clusters/cluster1/virtualMachines/vm-256")
 *             ))
 *             .resourceGroupName("group1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:PlacementPolicy policy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/clusters/{clusterName}/placementPolicies/{placementPolicyName}
 * ```
 */
public class PlacementPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.PlacementPolicy,
) : KotlinCustomResource(javaResource, PlacementPolicyMapper) {
    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * placement policy properties
     */
    public val properties:
        Output<Either<VmHostPlacementPolicyPropertiesResponse, VmVmPlacementPolicyPropertiesResponse>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.avs.kotlin.outputs.VmHostPlacementPolicyPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.avs.kotlin.outputs.VmVmPlacementPolicyPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
            )
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PlacementPolicyMapper : ResourceMapper<PlacementPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.PlacementPolicy::class == javaResource::class

    override fun map(javaResource: Resource): PlacementPolicy = PlacementPolicy(
        javaResource as
            com.pulumi.azurenative.avs.PlacementPolicy,
    )
}

/**
 * @see [PlacementPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PlacementPolicy].
 */
public suspend fun placementPolicy(
    name: String,
    block: suspend PlacementPolicyResourceBuilder.() -> Unit,
): PlacementPolicy {
    val builder = PlacementPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PlacementPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun placementPolicy(name: String): PlacementPolicy {
    val builder = PlacementPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
