@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.kotlin.outputs.AvailabilityPropertiesResponse
import com.pulumi.azurenative.avs.kotlin.outputs.CircuitResponse
import com.pulumi.azurenative.avs.kotlin.outputs.EncryptionResponse
import com.pulumi.azurenative.avs.kotlin.outputs.EndpointsResponse
import com.pulumi.azurenative.avs.kotlin.outputs.IdentitySourceResponse
import com.pulumi.azurenative.avs.kotlin.outputs.ManagementClusterResponse
import com.pulumi.azurenative.avs.kotlin.outputs.PrivateCloudIdentityResponse
import com.pulumi.azurenative.avs.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.avs.kotlin.outputs.AvailabilityPropertiesResponse.Companion.toKotlin as availabilityPropertiesResponseToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.CircuitResponse.Companion.toKotlin as circuitResponseToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.EncryptionResponse.Companion.toKotlin as encryptionResponseToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.EndpointsResponse.Companion.toKotlin as endpointsResponseToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.IdentitySourceResponse.Companion.toKotlin as identitySourceResponseToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.ManagementClusterResponse.Companion.toKotlin as managementClusterResponseToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.PrivateCloudIdentityResponse.Companion.toKotlin as privateCloudIdentityResponseToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [PrivateCloud].
 */
@PulumiTagMarker
public class PrivateCloudResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateCloudArgs = PrivateCloudArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateCloudArgsBuilder.() -> Unit) {
        val builder = PrivateCloudArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateCloud {
        val builtJavaResource = com.pulumi.azurenative.avs.PrivateCloud(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PrivateCloud(builtJavaResource)
    }
}

/**
 * A private cloud resource
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-03-20.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### PrivateClouds_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateCloud = new AzureNative.AVS.PrivateCloud("privateCloud", new()
 *     {
 *         Identity = new AzureNative.AVS.Inputs.PrivateCloudIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         Location = "eastus2",
 *         ManagementCluster = new AzureNative.AVS.Inputs.ManagementClusterArgs
 *         {
 *             ClusterSize = 4,
 *         },
 *         NetworkBlock = "192.168.48.0/22",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Sku = new AzureNative.AVS.Inputs.SkuArgs
 *         {
 *             Name = "AV36",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewPrivateCloud(ctx, "privateCloud", &avs.PrivateCloudArgs{
 * 			Identity: &avs.PrivateCloudIdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			Location: pulumi.String("eastus2"),
 * 			ManagementCluster: &avs.ManagementClusterArgs{
 * 				ClusterSize: pulumi.Int(4),
 * 			},
 * 			NetworkBlock:      pulumi.String("192.168.48.0/22"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Sku: &avs.SkuArgs{
 * 				Name: pulumi.String("AV36"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.PrivateCloud;
 * import com.pulumi.azurenative.avs.PrivateCloudArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateCloud = new PrivateCloud("privateCloud", PrivateCloudArgs.builder()
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("eastus2")
 *             .managementCluster(Map.of("clusterSize", 4))
 *             .networkBlock("192.168.48.0/22")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .sku(Map.of("name", "AV36"))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateClouds_CreateOrUpdate_Stretched
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateCloud = new AzureNative.AVS.PrivateCloud("privateCloud", new()
 *     {
 *         Availability = new AzureNative.AVS.Inputs.AvailabilityPropertiesArgs
 *         {
 *             SecondaryZone = 2,
 *             Strategy = "DualZone",
 *             Zone = 1,
 *         },
 *         Location = "eastus2",
 *         ManagementCluster = new AzureNative.AVS.Inputs.ManagementClusterArgs
 *         {
 *             ClusterSize = 4,
 *         },
 *         NetworkBlock = "192.168.48.0/22",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Sku = new AzureNative.AVS.Inputs.SkuArgs
 *         {
 *             Name = "AV36",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewPrivateCloud(ctx, "privateCloud", &avs.PrivateCloudArgs{
 * 			Availability: &avs.AvailabilityPropertiesArgs{
 * 				SecondaryZone: pulumi.Int(2),
 * 				Strategy:      pulumi.String("DualZone"),
 * 				Zone:          pulumi.Int(1),
 * 			},
 * 			Location: pulumi.String("eastus2"),
 * 			ManagementCluster: &avs.ManagementClusterArgs{
 * 				ClusterSize: pulumi.Int(4),
 * 			},
 * 			NetworkBlock:      pulumi.String("192.168.48.0/22"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Sku: &avs.SkuArgs{
 * 				Name: pulumi.String("AV36"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.PrivateCloud;
 * import com.pulumi.azurenative.avs.PrivateCloudArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateCloud = new PrivateCloud("privateCloud", PrivateCloudArgs.builder()
 *             .availability(Map.ofEntries(
 *                 Map.entry("secondaryZone", 2),
 *                 Map.entry("strategy", "DualZone"),
 *                 Map.entry("zone", 1)
 *             ))
 *             .location("eastus2")
 *             .managementCluster(Map.of("clusterSize", 4))
 *             .networkBlock("192.168.48.0/22")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .sku(Map.of("name", "AV36"))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:PrivateCloud cloud1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}
 * ```
 */
public class PrivateCloud internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.PrivateCloud,
) : KotlinCustomResource(javaResource, PrivateCloudMapper) {
    /**
     * Properties describing how the cloud is distributed across availability zones
     */
    public val availability: Output<AvailabilityPropertiesResponse>?
        get() = javaResource.availability().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    availabilityPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * An ExpressRoute Circuit
     */
    public val circuit: Output<CircuitResponse>?
        get() = javaResource.circuit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    circuitResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Customer managed key encryption, can be enabled or disabled
     */
    public val encryption: Output<EncryptionResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    encryptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The endpoints
     */
    public val endpoints: Output<EndpointsResponse>
        get() = javaResource.endpoints().applyValue({ args0 ->
            args0.let({ args0 ->
                endpointsResponseToKotlin(args0)
            })
        })

    /**
     * Array of cloud link IDs from other clouds that connect to this one
     */
    public val externalCloudLinks: Output<List<String>>
        get() = javaResource.externalCloudLinks().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The identity of the private cloud, if configured.
     */
    public val identity: Output<PrivateCloudIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    privateCloudIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * vCenter Single Sign On Identity Sources
     */
    public val identitySources: Output<List<IdentitySourceResponse>>?
        get() = javaResource.identitySources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        identitySourceResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Connectivity to internet is enabled or disabled
     */
    public val internet: Output<String>?
        get() = javaResource.internet().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The default cluster used for management
     */
    public val managementCluster: Output<ManagementClusterResponse>
        get() = javaResource.managementCluster().applyValue({ args0 ->
            args0.let({ args0 ->
                managementClusterResponseToKotlin(args0)
            })
        })

    /**
     * Network used to access vCenter Server and NSX-T Manager
     */
    public val managementNetwork: Output<String>
        get() = javaResource.managementNetwork().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The block of addresses should be unique across VNet in your subscription as well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where A,B,C,D are between 0 and 255, and X is between 0 and 22
     */
    public val networkBlock: Output<String>
        get() = javaResource.networkBlock().applyValue({ args0 -> args0 })

    /**
     * Flag to indicate whether the private cloud has the quota for provisioned NSX Public IP count raised from 64 to 1024
     */
    public val nsxPublicIpQuotaRaised: Output<String>
        get() = javaResource.nsxPublicIpQuotaRaised().applyValue({ args0 -> args0 })

    /**
     * Thumbprint of the NSX-T Manager SSL certificate
     */
    public val nsxtCertificateThumbprint: Output<String>
        get() = javaResource.nsxtCertificateThumbprint().applyValue({ args0 -> args0 })

    /**
     * Optionally, set the NSX-T Manager password when the private cloud is created
     */
    public val nsxtPassword: Output<String>?
        get() = javaResource.nsxtPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Used for virtual machine cold migration, cloning, and snapshot migration
     */
    public val provisioningNetwork: Output<String>
        get() = javaResource.provisioningNetwork().applyValue({ args0 -> args0 })

    /**
     * The provisioning state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * A secondary expressRoute circuit from a separate AZ. Only present in a stretched private cloud
     */
    public val secondaryCircuit: Output<CircuitResponse>?
        get() = javaResource.secondaryCircuit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> circuitResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The private cloud SKU
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Thumbprint of the vCenter Server SSL certificate
     */
    public val vcenterCertificateThumbprint: Output<String>
        get() = javaResource.vcenterCertificateThumbprint().applyValue({ args0 -> args0 })

    /**
     * Optionally, set the vCenter admin password when the private cloud is created
     */
    public val vcenterPassword: Output<String>?
        get() = javaResource.vcenterPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Used for live migration of virtual machines
     */
    public val vmotionNetwork: Output<String>
        get() = javaResource.vmotionNetwork().applyValue({ args0 -> args0 })
}

public object PrivateCloudMapper : ResourceMapper<PrivateCloud> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.PrivateCloud::class == javaResource::class

    override fun map(javaResource: Resource): PrivateCloud = PrivateCloud(
        javaResource as
            com.pulumi.azurenative.avs.PrivateCloud,
    )
}

/**
 * @see [PrivateCloud].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateCloud].
 */
public suspend fun privateCloud(
    name: String,
    block: suspend PrivateCloudResourceBuilder.() -> Unit,
): PrivateCloud {
    val builder = PrivateCloudResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateCloud].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateCloud(name: String): PrivateCloud {
    val builder = PrivateCloudResourceBuilder()
    builder.name(name)
    return builder.build()
}
