@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.kotlin.outputs.WorkloadNetworkSegmentPortVifResponse
import com.pulumi.azurenative.avs.kotlin.outputs.WorkloadNetworkSegmentSubnetResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.avs.kotlin.outputs.WorkloadNetworkSegmentPortVifResponse.Companion.toKotlin as workloadNetworkSegmentPortVifResponseToKotlin
import com.pulumi.azurenative.avs.kotlin.outputs.WorkloadNetworkSegmentSubnetResponse.Companion.toKotlin as workloadNetworkSegmentSubnetResponseToKotlin

/**
 * Builder for [WorkloadNetworkSegment].
 */
@PulumiTagMarker
public class WorkloadNetworkSegmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkloadNetworkSegmentArgs = WorkloadNetworkSegmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkloadNetworkSegmentArgsBuilder.() -> Unit) {
        val builder = WorkloadNetworkSegmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkloadNetworkSegment {
        val builtJavaResource =
            com.pulumi.azurenative.avs.WorkloadNetworkSegment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkloadNetworkSegment(builtJavaResource)
    }
}

/**
 * NSX Segment
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreateSegments
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkSegment = new AzureNative.AVS.WorkloadNetworkSegment("workloadNetworkSegment", new()
 *     {
 *         ConnectedGateway = "/infra/tier-1s/gateway",
 *         DisplayName = "segment1",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Revision = 1,
 *         SegmentId = "segment1",
 *         Subnet = new AzureNative.AVS.Inputs.WorkloadNetworkSegmentSubnetArgs
 *         {
 *             DhcpRanges = new[]
 *             {
 *                 "40.20.0.0-40.20.0.1",
 *             },
 *             GatewayAddress = "40.20.20.20/16",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkSegment(ctx, "workloadNetworkSegment", &avs.WorkloadNetworkSegmentArgs{
 * 			ConnectedGateway:  pulumi.String("/infra/tier-1s/gateway"),
 * 			DisplayName:       pulumi.String("segment1"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Revision:          pulumi.Float64(1),
 * 			SegmentId:         pulumi.String("segment1"),
 * 			Subnet: &avs.WorkloadNetworkSegmentSubnetArgs{
 * 				DhcpRanges: pulumi.StringArray{
 * 					pulumi.String("40.20.0.0-40.20.0.1"),
 * 				},
 * 				GatewayAddress: pulumi.String("40.20.20.20/16"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkSegment;
 * import com.pulumi.azurenative.avs.WorkloadNetworkSegmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkSegment = new WorkloadNetworkSegment("workloadNetworkSegment", WorkloadNetworkSegmentArgs.builder()
 *             .connectedGateway("/infra/tier-1s/gateway")
 *             .displayName("segment1")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .revision(1)
 *             .segmentId("segment1")
 *             .subnet(Map.ofEntries(
 *                 Map.entry("dhcpRanges", "40.20.0.0-40.20.0.1"),
 *                 Map.entry("gatewayAddress", "40.20.20.20/16")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkSegment segment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/segments/{segmentId}
 * ```
 */
public class WorkloadNetworkSegment internal constructor(
    override val javaResource: com.pulumi.azurenative.avs.WorkloadNetworkSegment,
) : KotlinCustomResource(javaResource, WorkloadNetworkSegmentMapper) {
    /**
     * Gateway which to connect segment to.
     */
    public val connectedGateway: Output<String>?
        get() = javaResource.connectedGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Display name of the segment.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Port Vif which segment is associated with.
     */
    public val portVif: Output<List<WorkloadNetworkSegmentPortVifResponse>>
        get() = javaResource.portVif().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    workloadNetworkSegmentPortVifResponseToKotlin(args0)
                })
            })
        })

    /**
     * The provisioning state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * NSX revision number.
     */
    public val revision: Output<Double>?
        get() = javaResource.revision().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Segment status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Subnet which to connect segment to.
     */
    public val subnet: Output<WorkloadNetworkSegmentSubnetResponse>?
        get() = javaResource.subnet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    workloadNetworkSegmentSubnetResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkloadNetworkSegmentMapper : ResourceMapper<WorkloadNetworkSegment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.avs.WorkloadNetworkSegment::class == javaResource::class

    override fun map(javaResource: Resource): WorkloadNetworkSegment =
        WorkloadNetworkSegment(javaResource as com.pulumi.azurenative.avs.WorkloadNetworkSegment)
}

/**
 * @see [WorkloadNetworkSegment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkloadNetworkSegment].
 */
public suspend fun workloadNetworkSegment(
    name: String,
    block: suspend WorkloadNetworkSegmentResourceBuilder.() -> Unit,
): WorkloadNetworkSegment {
    val builder = WorkloadNetworkSegmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkloadNetworkSegment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workloadNetworkSegment(name: String): WorkloadNetworkSegment {
    val builder = WorkloadNetworkSegmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
