@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin

import com.pulumi.azurenative.avs.WorkloadNetworkSegmentArgs.builder
import com.pulumi.azurenative.avs.kotlin.inputs.WorkloadNetworkSegmentSubnetArgs
import com.pulumi.azurenative.avs.kotlin.inputs.WorkloadNetworkSegmentSubnetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * NSX Segment
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-07-17-preview.
 * Other available API versions: 2023-03-01.
 * ## Example Usage
 * ### WorkloadNetworks_CreateSegments
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workloadNetworkSegment = new AzureNative.AVS.WorkloadNetworkSegment("workloadNetworkSegment", new()
 *     {
 *         ConnectedGateway = "/infra/tier-1s/gateway",
 *         DisplayName = "segment1",
 *         PrivateCloudName = "cloud1",
 *         ResourceGroupName = "group1",
 *         Revision = 1,
 *         SegmentId = "segment1",
 *         Subnet = new AzureNative.AVS.Inputs.WorkloadNetworkSegmentSubnetArgs
 *         {
 *             DhcpRanges = new[]
 *             {
 *                 "40.20.0.0-40.20.0.1",
 *             },
 *             GatewayAddress = "40.20.20.20/16",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/avs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := avs.NewWorkloadNetworkSegment(ctx, "workloadNetworkSegment", &avs.WorkloadNetworkSegmentArgs{
 * 			ConnectedGateway:  pulumi.String("/infra/tier-1s/gateway"),
 * 			DisplayName:       pulumi.String("segment1"),
 * 			PrivateCloudName:  pulumi.String("cloud1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Revision:          pulumi.Float64(1),
 * 			SegmentId:         pulumi.String("segment1"),
 * 			Subnet: &avs.WorkloadNetworkSegmentSubnetArgs{
 * 				DhcpRanges: pulumi.StringArray{
 * 					pulumi.String("40.20.0.0-40.20.0.1"),
 * 				},
 * 				GatewayAddress: pulumi.String("40.20.20.20/16"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.avs.WorkloadNetworkSegment;
 * import com.pulumi.azurenative.avs.WorkloadNetworkSegmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workloadNetworkSegment = new WorkloadNetworkSegment("workloadNetworkSegment", WorkloadNetworkSegmentArgs.builder()
 *             .connectedGateway("/infra/tier-1s/gateway")
 *             .displayName("segment1")
 *             .privateCloudName("cloud1")
 *             .resourceGroupName("group1")
 *             .revision(1)
 *             .segmentId("segment1")
 *             .subnet(Map.ofEntries(
 *                 Map.entry("dhcpRanges", "40.20.0.0-40.20.0.1"),
 *                 Map.entry("gatewayAddress", "40.20.20.20/16")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:avs:WorkloadNetworkSegment segment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AVS/privateClouds/{privateCloudName}/workloadNetworks/default/segments/{segmentId}
 * ```
 * @property connectedGateway Gateway which to connect segment to.
 * @property displayName Display name of the segment.
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property revision NSX revision number.
 * @property segmentId NSX Segment identifier. Generally the same as the Segment's display name
 * @property subnet Subnet which to connect segment to.
 */
public data class WorkloadNetworkSegmentArgs(
    public val connectedGateway: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val privateCloudName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val revision: Output<Double>? = null,
    public val segmentId: Output<String>? = null,
    public val subnet: Output<WorkloadNetworkSegmentSubnetArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.WorkloadNetworkSegmentArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.WorkloadNetworkSegmentArgs =
        com.pulumi.azurenative.avs.WorkloadNetworkSegmentArgs.builder()
            .connectedGateway(connectedGateway?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .privateCloudName(privateCloudName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .revision(revision?.applyValue({ args0 -> args0 }))
            .segmentId(segmentId?.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WorkloadNetworkSegmentArgs].
 */
@PulumiTagMarker
public class WorkloadNetworkSegmentArgsBuilder internal constructor() {
    private var connectedGateway: Output<String>? = null

    private var displayName: Output<String>? = null

    private var privateCloudName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var revision: Output<Double>? = null

    private var segmentId: Output<String>? = null

    private var subnet: Output<WorkloadNetworkSegmentSubnetArgs>? = null

    /**
     * @param value Gateway which to connect segment to.
     */
    @JvmName("fjoasdqbxbpljtps")
    public suspend fun connectedGateway(`value`: Output<String>) {
        this.connectedGateway = value
    }

    /**
     * @param value Display name of the segment.
     */
    @JvmName("wpdjxmetfacfvbns")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("tbhpaehrqcvvetbk")
    public suspend fun privateCloudName(`value`: Output<String>) {
        this.privateCloudName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bjgfnmmvnfubjglk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("sltukvnsxijxiycf")
    public suspend fun revision(`value`: Output<Double>) {
        this.revision = value
    }

    /**
     * @param value NSX Segment identifier. Generally the same as the Segment's display name
     */
    @JvmName("pxcyaetgqhvquyod")
    public suspend fun segmentId(`value`: Output<String>) {
        this.segmentId = value
    }

    /**
     * @param value Subnet which to connect segment to.
     */
    @JvmName("ukjlabfuqadauqnq")
    public suspend fun subnet(`value`: Output<WorkloadNetworkSegmentSubnetArgs>) {
        this.subnet = value
    }

    /**
     * @param value Gateway which to connect segment to.
     */
    @JvmName("qgihjawtsggitbja")
    public suspend fun connectedGateway(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectedGateway = mapped
    }

    /**
     * @param value Display name of the segment.
     */
    @JvmName("dqjspdhbucncolyi")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("fsikcjycuptvhcqc")
    public suspend fun privateCloudName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qrcqeccowcnavijw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value NSX revision number.
     */
    @JvmName("svebmwoncxtfydbs")
    public suspend fun revision(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revision = mapped
    }

    /**
     * @param value NSX Segment identifier. Generally the same as the Segment's display name
     */
    @JvmName("jwibnbvnaseuqysb")
    public suspend fun segmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentId = mapped
    }

    /**
     * @param value Subnet which to connect segment to.
     */
    @JvmName("ntwdfgjgplrcvlom")
    public suspend fun subnet(`value`: WorkloadNetworkSegmentSubnetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Subnet which to connect segment to.
     */
    @JvmName("hngslgkpvhuatqvx")
    public suspend fun subnet(argument: suspend WorkloadNetworkSegmentSubnetArgsBuilder.() -> Unit) {
        val toBeMapped = WorkloadNetworkSegmentSubnetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): WorkloadNetworkSegmentArgs = WorkloadNetworkSegmentArgs(
        connectedGateway = connectedGateway,
        displayName = displayName,
        privateCloudName = privateCloudName,
        resourceGroupName = resourceGroupName,
        revision = revision,
        segmentId = segmentId,
        subnet = subnet,
    )
}
