@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.EncryptionKeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Encryption Key
 * @property keyName The name of the key.
 * @property keyVaultUrl The URL of the vault.
 * @property keyVersion The version of the key.
 */
public data class EncryptionKeyVaultPropertiesArgs(
    public val keyName: Output<String>? = null,
    public val keyVaultUrl: Output<String>? = null,
    public val keyVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.EncryptionKeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.EncryptionKeyVaultPropertiesArgs =
        com.pulumi.azurenative.avs.inputs.EncryptionKeyVaultPropertiesArgs.builder()
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keyVaultUrl(keyVaultUrl?.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionKeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class EncryptionKeyVaultPropertiesArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyVaultUrl: Output<String>? = null

    private var keyVersion: Output<String>? = null

    /**
     * @param value The name of the key.
     */
    @JvmName("wxfupbjirasohddv")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The URL of the vault.
     */
    @JvmName("gqwwbdstgiphjdgi")
    public suspend fun keyVaultUrl(`value`: Output<String>) {
        this.keyVaultUrl = value
    }

    /**
     * @param value The version of the key.
     */
    @JvmName("mbhofbexyhkhycxl")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value The name of the key.
     */
    @JvmName("lrrxlmdpbsiwrptt")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The URL of the vault.
     */
    @JvmName("bokiiwqihmlsoehp")
    public suspend fun keyVaultUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUrl = mapped
    }

    /**
     * @param value The version of the key.
     */
    @JvmName("sfxtfswqpnoskvri")
    public suspend fun keyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    internal fun build(): EncryptionKeyVaultPropertiesArgs = EncryptionKeyVaultPropertiesArgs(
        keyName = keyName,
        keyVaultUrl = keyVaultUrl,
        keyVersion = keyVersion,
    )
}
