@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetCloudLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudLinkName Name of the cloud link resource
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCloudLinkPlainArgs(
    public val cloudLinkName: String,
    public val privateCloudName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetCloudLinkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetCloudLinkPlainArgs =
        com.pulumi.azurenative.avs.inputs.GetCloudLinkPlainArgs.builder()
            .cloudLinkName(cloudLinkName.let({ args0 -> args0 }))
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCloudLinkPlainArgs].
 */
@PulumiTagMarker
public class GetCloudLinkPlainArgsBuilder internal constructor() {
    private var cloudLinkName: String? = null

    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the cloud link resource
     */
    @JvmName("bgxdqoupsonplgdc")
    public suspend fun cloudLinkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cloudLinkName = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("docojiygyvdwrpvy")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dxsradqpljtwoqkj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCloudLinkPlainArgs = GetCloudLinkPlainArgs(
        cloudLinkName = cloudLinkName ?: throw PulumiNullFieldException("cloudLinkName"),
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
