@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetScriptExecutionLogsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scriptExecutionName Name of the user-invoked script execution resource
 */
public data class GetScriptExecutionLogsPlainArgs(
    public val privateCloudName: String,
    public val resourceGroupName: String,
    public val scriptExecutionName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetScriptExecutionLogsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetScriptExecutionLogsPlainArgs =
        com.pulumi.azurenative.avs.inputs.GetScriptExecutionLogsPlainArgs.builder()
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .scriptExecutionName(scriptExecutionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScriptExecutionLogsPlainArgs].
 */
@PulumiTagMarker
public class GetScriptExecutionLogsPlainArgsBuilder internal constructor() {
    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    private var scriptExecutionName: String? = null

    /**
     * @param value Name of the private cloud
     */
    @JvmName("qaukyusbhogteyeu")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ugpfpalqhpjvvuxe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the user-invoked script execution resource
     */
    @JvmName("eoqmogpouiqyyhrd")
    public suspend fun scriptExecutionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scriptExecutionName = mapped
    }

    internal fun build(): GetScriptExecutionLogsPlainArgs = GetScriptExecutionLogsPlainArgs(
        privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        scriptExecutionName = scriptExecutionName ?: throw PulumiNullFieldException("scriptExecutionName"),
    )
}
