@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkDnsServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dnsServiceId NSX DNS Service identifier. Generally the same as the DNS Service's display name
 * @property privateCloudName Name of the private cloud
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetWorkloadNetworkDnsServicePlainArgs(
    public val dnsServiceId: String,
    public val privateCloudName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkDnsServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkDnsServicePlainArgs =
        com.pulumi.azurenative.avs.inputs.GetWorkloadNetworkDnsServicePlainArgs.builder()
            .dnsServiceId(dnsServiceId.let({ args0 -> args0 }))
            .privateCloudName(privateCloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkloadNetworkDnsServicePlainArgs].
 */
@PulumiTagMarker
public class GetWorkloadNetworkDnsServicePlainArgsBuilder internal constructor() {
    private var dnsServiceId: String? = null

    private var privateCloudName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value NSX DNS Service identifier. Generally the same as the DNS Service's display name
     */
    @JvmName("ybxtqeikmsxfrtdt")
    public suspend fun dnsServiceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dnsServiceId = mapped
    }

    /**
     * @param value Name of the private cloud
     */
    @JvmName("fhrgiyureqqmvvec")
    public suspend fun privateCloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateCloudName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("teurfjbonndatdxu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWorkloadNetworkDnsServicePlainArgs =
        GetWorkloadNetworkDnsServicePlainArgs(
            dnsServiceId = dnsServiceId ?: throw PulumiNullFieldException("dnsServiceId"),
            privateCloudName = privateCloudName ?: throw PulumiNullFieldException("privateCloudName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
