@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.NetAppVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Azure NetApp Files volume from Microsoft.NetApp provider
 * @property id Azure resource ID of the NetApp volume
 */
public data class NetAppVolumeArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.NetAppVolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.NetAppVolumeArgs =
        com.pulumi.azurenative.avs.inputs.NetAppVolumeArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetAppVolumeArgs].
 */
@PulumiTagMarker
public class NetAppVolumeArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Azure resource ID of the NetApp volume
     */
    @JvmName("fmjcidglpdvthwbg")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Azure resource ID of the NetApp volume
     */
    @JvmName("fmsriatrfchqvfrg")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): NetAppVolumeArgs = NetAppVolumeArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
