@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.ScriptSecureStringExecutionParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * a plain text value execution parameter
 * @property name The parameter name
 * @property secureValue A secure value for the passed parameter, not to be stored in logs
 * @property type The type of execution parameter
 * Expected value is 'SecureValue'.
 */
public data class ScriptSecureStringExecutionParameterArgs(
    public val name: Output<String>,
    public val secureValue: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.ScriptSecureStringExecutionParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.ScriptSecureStringExecutionParameterArgs =
        com.pulumi.azurenative.avs.inputs.ScriptSecureStringExecutionParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .secureValue(secureValue?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScriptSecureStringExecutionParameterArgs].
 */
@PulumiTagMarker
public class ScriptSecureStringExecutionParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var secureValue: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The parameter name
     */
    @JvmName("xokxsobrrkbwhawt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A secure value for the passed parameter, not to be stored in logs
     */
    @JvmName("tapgbmokelbuurwj")
    public suspend fun secureValue(`value`: Output<String>) {
        this.secureValue = value
    }

    /**
     * @param value The type of execution parameter
     * Expected value is 'SecureValue'.
     */
    @JvmName("osfomobbwiylbswd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The parameter name
     */
    @JvmName("dvnpsreeiqrawysu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A secure value for the passed parameter, not to be stored in logs
     */
    @JvmName("nxokbmywaneiiogs")
    public suspend fun secureValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureValue = mapped
    }

    /**
     * @param value The type of execution parameter
     * Expected value is 'SecureValue'.
     */
    @JvmName("sturcccdpggjjnyv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ScriptSecureStringExecutionParameterArgs =
        ScriptSecureStringExecutionParameterArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            secureValue = secureValue,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
