@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.inputs

import com.pulumi.azurenative.avs.inputs.WorkloadNetworkSegmentSubnetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Subnet configuration for segment
 * @property dhcpRanges DHCP Range assigned for subnet.
 * @property gatewayAddress Gateway address.
 */
public data class WorkloadNetworkSegmentSubnetArgs(
    public val dhcpRanges: Output<List<String>>? = null,
    public val gatewayAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.avs.inputs.WorkloadNetworkSegmentSubnetArgs> {
    override fun toJava(): com.pulumi.azurenative.avs.inputs.WorkloadNetworkSegmentSubnetArgs =
        com.pulumi.azurenative.avs.inputs.WorkloadNetworkSegmentSubnetArgs.builder()
            .dhcpRanges(dhcpRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .gatewayAddress(gatewayAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadNetworkSegmentSubnetArgs].
 */
@PulumiTagMarker
public class WorkloadNetworkSegmentSubnetArgsBuilder internal constructor() {
    private var dhcpRanges: Output<List<String>>? = null

    private var gatewayAddress: Output<String>? = null

    /**
     * @param value DHCP Range assigned for subnet.
     */
    @JvmName("rrjiihjaxmopwhwe")
    public suspend fun dhcpRanges(`value`: Output<List<String>>) {
        this.dhcpRanges = value
    }

    @JvmName("hwhmvkpxfhjyxqtr")
    public suspend fun dhcpRanges(vararg values: Output<String>) {
        this.dhcpRanges = Output.all(values.asList())
    }

    /**
     * @param values DHCP Range assigned for subnet.
     */
    @JvmName("ngphbmdehiimsnjw")
    public suspend fun dhcpRanges(values: List<Output<String>>) {
        this.dhcpRanges = Output.all(values)
    }

    /**
     * @param value Gateway address.
     */
    @JvmName("ndirkkpbvypgfgrg")
    public suspend fun gatewayAddress(`value`: Output<String>) {
        this.gatewayAddress = value
    }

    /**
     * @param value DHCP Range assigned for subnet.
     */
    @JvmName("owqnsseejwumfbdb")
    public suspend fun dhcpRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dhcpRanges = mapped
    }

    /**
     * @param values DHCP Range assigned for subnet.
     */
    @JvmName("cdychhufivvjuxkx")
    public suspend fun dhcpRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dhcpRanges = mapped
    }

    /**
     * @param value Gateway address.
     */
    @JvmName("siblwkiprorvasbt")
    public suspend fun gatewayAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayAddress = mapped
    }

    internal fun build(): WorkloadNetworkSegmentSubnetArgs = WorkloadNetworkSegmentSubnetArgs(
        dhcpRanges = dhcpRanges,
        gatewayAddress = gatewayAddress,
    )
}
