@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The properties describing private cloud availability zone distribution
 * @property secondaryZone The secondary availability zone for the private cloud
 * @property strategy The availability strategy for the private cloud
 * @property zone The primary availability zone for the private cloud
 */
public data class AvailabilityPropertiesResponse(
    public val secondaryZone: Int? = null,
    public val strategy: String? = null,
    public val zone: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.AvailabilityPropertiesResponse):
            AvailabilityPropertiesResponse = AvailabilityPropertiesResponse(
            secondaryZone = javaType.secondaryZone().map({ args0 -> args0 }).orElse(null),
            strategy = javaType.strategy().map({ args0 -> args0 }).orElse(null),
            zone = javaType.zone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
