@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An iSCSI volume from Microsoft.StoragePool provider
 * @property lunName Name of the LUN to be used for datastore
 * @property mountOption Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN
 * @property path Device path
 * @property targetId Azure resource ID of the iSCSI target
 */
public data class DiskPoolVolumeResponse(
    public val lunName: String,
    public val mountOption: String? = null,
    public val path: String,
    public val targetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.DiskPoolVolumeResponse):
            DiskPoolVolumeResponse = DiskPoolVolumeResponse(
            lunName = javaType.lunName(),
            mountOption = javaType.mountOption().map({ args0 -> args0 }).orElse(null),
            path = javaType.path(),
            targetId = javaType.targetId(),
        )
    }
}
