@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * NSX DNS Service
 * @property defaultDnsZone Default DNS zone of the DNS Service.
 * @property displayName Display name of the DNS Service.
 * @property dnsServiceIp DNS service IP of the DNS Service.
 * @property fqdnZones FQDN zones of the DNS Service.
 * @property id Resource ID.
 * @property logLevel DNS Service log level.
 * @property name Resource name.
 * @property provisioningState The provisioning state
 * @property revision NSX revision number.
 * @property status DNS Service status.
 * @property type Resource type.
 */
public data class GetWorkloadNetworkDnsServiceResult(
    public val defaultDnsZone: String? = null,
    public val displayName: String? = null,
    public val dnsServiceIp: String? = null,
    public val fqdnZones: List<String>? = null,
    public val id: String,
    public val logLevel: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val revision: Double? = null,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetWorkloadNetworkDnsServiceResult):
            GetWorkloadNetworkDnsServiceResult = GetWorkloadNetworkDnsServiceResult(
            defaultDnsZone = javaType.defaultDnsZone().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            dnsServiceIp = javaType.dnsServiceIp().map({ args0 -> args0 }).orElse(null),
            fqdnZones = javaType.fqdnZones().map({ args0 -> args0 }),
            id = javaType.id(),
            logLevel = javaType.logLevel().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            revision = javaType.revision().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
