@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * NSX DNS Zone
 * @property displayName Display name of the DNS Zone.
 * @property dnsServerIps DNS Server IP array of the DNS Zone.
 * @property dnsServices Number of DNS Services using the DNS zone.
 * @property domain Domain names of the DNS Zone.
 * @property id Resource ID.
 * @property name Resource name.
 * @property provisioningState The provisioning state
 * @property revision NSX revision number.
 * @property sourceIp Source IP of the DNS Zone.
 * @property type Resource type.
 */
public data class GetWorkloadNetworkDnsZoneResult(
    public val displayName: String? = null,
    public val dnsServerIps: List<String>? = null,
    public val dnsServices: Double? = null,
    public val domain: List<String>? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val revision: Double? = null,
    public val sourceIp: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetWorkloadNetworkDnsZoneResult):
            GetWorkloadNetworkDnsZoneResult = GetWorkloadNetworkDnsZoneResult(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            dnsServerIps = javaType.dnsServerIps().map({ args0 -> args0 }),
            dnsServices = javaType.dnsServices().map({ args0 -> args0 }).orElse(null),
            domain = javaType.domain().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            revision = javaType.revision().map({ args0 -> args0 }).orElse(null),
            sourceIp = javaType.sourceIp().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
