@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * NSX DHCP Relay
 * @property dhcpType Type of DHCP: SERVER or RELAY.
 * Expected value is 'RELAY'.
 * @property displayName Display name of the DHCP entity.
 * @property provisioningState The provisioning state
 * @property revision NSX revision number.
 * @property segments NSX Segments consuming DHCP.
 * @property serverAddresses DHCP Relay Addresses. Max 3.
 */
public data class WorkloadNetworkDhcpRelayResponse(
    public val dhcpType: String,
    public val displayName: String? = null,
    public val provisioningState: String,
    public val revision: Double? = null,
    public val segments: List<String>,
    public val serverAddresses: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.WorkloadNetworkDhcpRelayResponse):
            WorkloadNetworkDhcpRelayResponse = WorkloadNetworkDhcpRelayResponse(
            dhcpType = javaType.dhcpType(),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            revision = javaType.revision().map({ args0 -> args0 }).orElse(null),
            segments = javaType.segments().map({ args0 -> args0 }),
            serverAddresses = javaType.serverAddresses().map({ args0 -> args0 }),
        )
    }
}
